#[doc = "Register `AESACTL0` reader"]
pub struct R(crate::R<AESACTL0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AESACTL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<AESACTL0_SPEC>> for R {
    fn from(reader: crate::R<AESACTL0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AESACTL0` writer"]
pub struct W(crate::W<AESACTL0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AESACTL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<AESACTL0_SPEC>> for W {
    fn from(writer: crate::W<AESACTL0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "AES Operation Bit: 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum AESOP_A {
    #[doc = "0: AES Operation: Encrypt"]
    AESOP_0 = 0,
    #[doc = "1: AES Operation: Decrypt (same Key)"]
    AESOP_1 = 1,
    #[doc = "2: AES Operation: Generate first round Key"]
    AESOP_2 = 2,
    #[doc = "3: AES Operation: Decrypt (first round Key)"]
    AESOP_3 = 3,
}
impl From<AESOP_A> for u8 {
    #[inline(always)]
    fn from(variant: AESOP_A) -> Self {
        variant as _
    }
}
#[doc = "Field `AESOP` reader - AES Operation Bit: 0"]
pub struct AESOP_R(crate::FieldReader<u8, AESOP_A>);
impl AESOP_R {
    pub(crate) fn new(bits: u8) -> Self {
        AESOP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AESOP_A {
        match self.bits {
            0 => AESOP_A::AESOP_0,
            1 => AESOP_A::AESOP_1,
            2 => AESOP_A::AESOP_2,
            3 => AESOP_A::AESOP_3,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `AESOP_0`"]
    #[inline(always)]
    pub fn is_aesop_0(&self) -> bool {
        **self == AESOP_A::AESOP_0
    }
    #[doc = "Checks if the value of the field is `AESOP_1`"]
    #[inline(always)]
    pub fn is_aesop_1(&self) -> bool {
        **self == AESOP_A::AESOP_1
    }
    #[doc = "Checks if the value of the field is `AESOP_2`"]
    #[inline(always)]
    pub fn is_aesop_2(&self) -> bool {
        **self == AESOP_A::AESOP_2
    }
    #[doc = "Checks if the value of the field is `AESOP_3`"]
    #[inline(always)]
    pub fn is_aesop_3(&self) -> bool {
        **self == AESOP_A::AESOP_3
    }
}
impl core::ops::Deref for AESOP_R {
    type Target = crate::FieldReader<u8, AESOP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESOP` writer - AES Operation Bit: 0"]
pub struct AESOP_W<'a> {
    w: &'a mut W,
}
impl<'a> AESOP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AESOP_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "AES Operation: Encrypt"]
    #[inline(always)]
    pub fn aesop_0(self) -> &'a mut W {
        self.variant(AESOP_A::AESOP_0)
    }
    #[doc = "AES Operation: Decrypt (same Key)"]
    #[inline(always)]
    pub fn aesop_1(self) -> &'a mut W {
        self.variant(AESOP_A::AESOP_1)
    }
    #[doc = "AES Operation: Generate first round Key"]
    #[inline(always)]
    pub fn aesop_2(self) -> &'a mut W {
        self.variant(AESOP_A::AESOP_2)
    }
    #[doc = "AES Operation: Decrypt (first round Key)"]
    #[inline(always)]
    pub fn aesop_3(self) -> &'a mut W {
        self.variant(AESOP_A::AESOP_3)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u16 & 0x03);
        self.w
    }
}
#[doc = "AES Key length Bit: 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum AESKL_A {
    #[doc = "0: AES Key length: AES128"]
    AESKL_0 = 0,
    #[doc = "1: AES Key length: AES192"]
    AESKL_1 = 1,
    #[doc = "2: AES Key length: AES256"]
    AESKL_2 = 2,
}
impl From<AESKL_A> for u8 {
    #[inline(always)]
    fn from(variant: AESKL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `AESKL` reader - AES Key length Bit: 0"]
pub struct AESKL_R(crate::FieldReader<u8, AESKL_A>);
impl AESKL_R {
    pub(crate) fn new(bits: u8) -> Self {
        AESKL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<AESKL_A> {
        match self.bits {
            0 => Some(AESKL_A::AESKL_0),
            1 => Some(AESKL_A::AESKL_1),
            2 => Some(AESKL_A::AESKL_2),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `AESKL_0`"]
    #[inline(always)]
    pub fn is_aeskl_0(&self) -> bool {
        **self == AESKL_A::AESKL_0
    }
    #[doc = "Checks if the value of the field is `AESKL_1`"]
    #[inline(always)]
    pub fn is_aeskl_1(&self) -> bool {
        **self == AESKL_A::AESKL_1
    }
    #[doc = "Checks if the value of the field is `AESKL_2`"]
    #[inline(always)]
    pub fn is_aeskl_2(&self) -> bool {
        **self == AESKL_A::AESKL_2
    }
}
impl core::ops::Deref for AESKL_R {
    type Target = crate::FieldReader<u8, AESKL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESKL` writer - AES Key length Bit: 0"]
pub struct AESKL_W<'a> {
    w: &'a mut W,
}
impl<'a> AESKL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AESKL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "AES Key length: AES128"]
    #[inline(always)]
    pub fn aeskl_0(self) -> &'a mut W {
        self.variant(AESKL_A::AESKL_0)
    }
    #[doc = "AES Key length: AES192"]
    #[inline(always)]
    pub fn aeskl_1(self) -> &'a mut W {
        self.variant(AESKL_A::AESKL_1)
    }
    #[doc = "AES Key length: AES256"]
    #[inline(always)]
    pub fn aeskl_2(self) -> &'a mut W {
        self.variant(AESKL_A::AESKL_2)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u16 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `AESTRIG` reader - AES Trigger Select"]
pub struct AESTRIG_R(crate::FieldReader<bool, bool>);
impl AESTRIG_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESTRIG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESTRIG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESTRIG` writer - AES Trigger Select"]
pub struct AESTRIG_W<'a> {
    w: &'a mut W,
}
impl<'a> AESTRIG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u16 & 0x01) << 4);
        self.w
    }
}
#[doc = "AES Cipher mode select Bit: 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum AESCM_A {
    #[doc = "0: AES Cipher mode select: ECB"]
    AESCM_0 = 0,
    #[doc = "1: AES Cipher mode select: CBC"]
    AESCM_1 = 1,
    #[doc = "2: AES Cipher mode select: OFB"]
    AESCM_2 = 2,
    #[doc = "3: AES Cipher mode select: CFB"]
    AESCM_3 = 3,
}
impl From<AESCM_A> for u8 {
    #[inline(always)]
    fn from(variant: AESCM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `AESCM` reader - AES Cipher mode select Bit: 0"]
pub struct AESCM_R(crate::FieldReader<u8, AESCM_A>);
impl AESCM_R {
    pub(crate) fn new(bits: u8) -> Self {
        AESCM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AESCM_A {
        match self.bits {
            0 => AESCM_A::AESCM_0,
            1 => AESCM_A::AESCM_1,
            2 => AESCM_A::AESCM_2,
            3 => AESCM_A::AESCM_3,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `AESCM_0`"]
    #[inline(always)]
    pub fn is_aescm_0(&self) -> bool {
        **self == AESCM_A::AESCM_0
    }
    #[doc = "Checks if the value of the field is `AESCM_1`"]
    #[inline(always)]
    pub fn is_aescm_1(&self) -> bool {
        **self == AESCM_A::AESCM_1
    }
    #[doc = "Checks if the value of the field is `AESCM_2`"]
    #[inline(always)]
    pub fn is_aescm_2(&self) -> bool {
        **self == AESCM_A::AESCM_2
    }
    #[doc = "Checks if the value of the field is `AESCM_3`"]
    #[inline(always)]
    pub fn is_aescm_3(&self) -> bool {
        **self == AESCM_A::AESCM_3
    }
}
impl core::ops::Deref for AESCM_R {
    type Target = crate::FieldReader<u8, AESCM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESCM` writer - AES Cipher mode select Bit: 0"]
pub struct AESCM_W<'a> {
    w: &'a mut W,
}
impl<'a> AESCM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: AESCM_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "AES Cipher mode select: ECB"]
    #[inline(always)]
    pub fn aescm_0(self) -> &'a mut W {
        self.variant(AESCM_A::AESCM_0)
    }
    #[doc = "AES Cipher mode select: CBC"]
    #[inline(always)]
    pub fn aescm_1(self) -> &'a mut W {
        self.variant(AESCM_A::AESCM_1)
    }
    #[doc = "AES Cipher mode select: OFB"]
    #[inline(always)]
    pub fn aescm_2(self) -> &'a mut W {
        self.variant(AESCM_A::AESCM_2)
    }
    #[doc = "AES Cipher mode select: CFB"]
    #[inline(always)]
    pub fn aescm_3(self) -> &'a mut W {
        self.variant(AESCM_A::AESCM_3)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 5)) | ((value as u16 & 0x03) << 5);
        self.w
    }
}
#[doc = "Field `AESSWRST` reader - AES Software Reset"]
pub struct AESSWRST_R(crate::FieldReader<bool, bool>);
impl AESSWRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESSWRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESSWRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESSWRST` writer - AES Software Reset"]
pub struct AESSWRST_W<'a> {
    w: &'a mut W,
}
impl<'a> AESSWRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u16 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `AESRDYIFG` reader - AES ready interrupt flag"]
pub struct AESRDYIFG_R(crate::FieldReader<bool, bool>);
impl AESRDYIFG_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESRDYIFG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESRDYIFG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESRDYIFG` writer - AES ready interrupt flag"]
pub struct AESRDYIFG_W<'a> {
    w: &'a mut W,
}
impl<'a> AESRDYIFG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u16 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `AESERRFG` reader - AES Error Flag"]
pub struct AESERRFG_R(crate::FieldReader<bool, bool>);
impl AESERRFG_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESERRFG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESERRFG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESERRFG` writer - AES Error Flag"]
pub struct AESERRFG_W<'a> {
    w: &'a mut W,
}
impl<'a> AESERRFG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u16 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `AESRDYIE` reader - AES ready interrupt enable"]
pub struct AESRDYIE_R(crate::FieldReader<bool, bool>);
impl AESRDYIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESRDYIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESRDYIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESRDYIE` writer - AES ready interrupt enable"]
pub struct AESRDYIE_W<'a> {
    w: &'a mut W,
}
impl<'a> AESRDYIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u16 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `AESCMEN` reader - AES DMA cipher mode enable"]
pub struct AESCMEN_R(crate::FieldReader<bool, bool>);
impl AESCMEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        AESCMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AESCMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AESCMEN` writer - AES DMA cipher mode enable"]
pub struct AESCMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> AESCMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - AES Operation Bit: 0"]
    #[inline(always)]
    pub fn aesop(&self) -> AESOP_R {
        AESOP_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - AES Key length Bit: 0"]
    #[inline(always)]
    pub fn aeskl(&self) -> AESKL_R {
        AESKL_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 4 - AES Trigger Select"]
    #[inline(always)]
    pub fn aestrig(&self) -> AESTRIG_R {
        AESTRIG_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bits 5:6 - AES Cipher mode select Bit: 0"]
    #[inline(always)]
    pub fn aescm(&self) -> AESCM_R {
        AESCM_R::new(((self.bits >> 5) & 0x03) as u8)
    }
    #[doc = "Bit 7 - AES Software Reset"]
    #[inline(always)]
    pub fn aesswrst(&self) -> AESSWRST_R {
        AESSWRST_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - AES ready interrupt flag"]
    #[inline(always)]
    pub fn aesrdyifg(&self) -> AESRDYIFG_R {
        AESRDYIFG_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 11 - AES Error Flag"]
    #[inline(always)]
    pub fn aeserrfg(&self) -> AESERRFG_R {
        AESERRFG_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - AES ready interrupt enable"]
    #[inline(always)]
    pub fn aesrdyie(&self) -> AESRDYIE_R {
        AESRDYIE_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 15 - AES DMA cipher mode enable"]
    #[inline(always)]
    pub fn aescmen(&self) -> AESCMEN_R {
        AESCMEN_R::new(((self.bits >> 15) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - AES Operation Bit: 0"]
    #[inline(always)]
    pub fn aesop(&mut self) -> AESOP_W {
        AESOP_W { w: self }
    }
    #[doc = "Bits 2:3 - AES Key length Bit: 0"]
    #[inline(always)]
    pub fn aeskl(&mut self) -> AESKL_W {
        AESKL_W { w: self }
    }
    #[doc = "Bit 4 - AES Trigger Select"]
    #[inline(always)]
    pub fn aestrig(&mut self) -> AESTRIG_W {
        AESTRIG_W { w: self }
    }
    #[doc = "Bits 5:6 - AES Cipher mode select Bit: 0"]
    #[inline(always)]
    pub fn aescm(&mut self) -> AESCM_W {
        AESCM_W { w: self }
    }
    #[doc = "Bit 7 - AES Software Reset"]
    #[inline(always)]
    pub fn aesswrst(&mut self) -> AESSWRST_W {
        AESSWRST_W { w: self }
    }
    #[doc = "Bit 8 - AES ready interrupt flag"]
    #[inline(always)]
    pub fn aesrdyifg(&mut self) -> AESRDYIFG_W {
        AESRDYIFG_W { w: self }
    }
    #[doc = "Bit 11 - AES Error Flag"]
    #[inline(always)]
    pub fn aeserrfg(&mut self) -> AESERRFG_W {
        AESERRFG_W { w: self }
    }
    #[doc = "Bit 12 - AES ready interrupt enable"]
    #[inline(always)]
    pub fn aesrdyie(&mut self) -> AESRDYIE_W {
        AESRDYIE_W { w: self }
    }
    #[doc = "Bit 15 - AES DMA cipher mode enable"]
    #[inline(always)]
    pub fn aescmen(&mut self) -> AESCMEN_W {
        AESCMEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AES accelerator control register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [aesactl0](index.html) module"]
pub struct AESACTL0_SPEC;
impl crate::RegisterSpec for AESACTL0_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [aesactl0::R](R) reader structure"]
impl crate::Readable for AESACTL0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [aesactl0::W](W) writer structure"]
impl crate::Writable for AESACTL0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AESACTL0 to value 0"]
impl crate::Resettable for AESACTL0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
