use std::{array::IntoIter, env, fs, path::PathBuf};

fn main() {
    if env::var_os("CARGO_FEATURE_RT").is_none() {
        println!("cargo:rerun-if-changed=build.rs");
        return;
    }
    let mut devices = DEVICES
        .iter()
        .filter(|d| env::var_os(&format!("CARGO_FEATURE_{}", d.to_uppercase())).is_some());
    let device = match (devices.next(), devices.next()) {
        (None, _) => panic!(r#""rt" feature selected with no device feature"#),
        (Some(d), None) => d,
        (Some(d1), Some(d2)) => panic!(
            r#""rt" feature selected with multiple device features: {:?}"#,
            IntoIter::new([d1, d2]).chain(devices).collect::<Vec<_>>()
        ),
    };

    let out = &PathBuf::from(env::var_os("OUT_DIR").unwrap());
    fs::write(
        out.join("use_interrupt.rs"),
        format!(
            "pub use devices::{}::Interrupt as interrupt;\npub use msp430_rt::interrupt;",
            device
        ),
    )
    .unwrap();

    fs::copy(
        format!("src/linker/{}_device.x", device),
        out.join("device.x"),
    )
    .unwrap();
    fs::copy(
        format!("src/linker/{}_memory.x", device),
        out.join("memory.x"),
    )
    .unwrap();
    println!("cargo:rustc-link-search={}", out.display());

    println!("cargo:rerun-if-changed=src/linker/{}_device.x", device);
    println!("cargo:rerun-if-changed=src/linker/{}_memory.x", device);
}

const DEVICES: &[&str] = &[
    "cc430f5123",
    "cc430f5125",
    "cc430f5133",
    "cc430f5135",
    "cc430f5137",
    "cc430f5143",
    "cc430f5145",
    "cc430f5147",
    "cc430f6125",
    "cc430f6126",
    "cc430f6127",
    "cc430f6135",
    "cc430f6137",
    "cc430f6143",
    "cc430f6145",
    "cc430f6147",
    "msp430afe221",
    "msp430afe222",
    "msp430afe223",
    "msp430afe231",
    "msp430afe232",
    "msp430afe233",
    "msp430afe251",
    "msp430afe252",
    "msp430afe253",
    "msp430bt5190",
    "msp430c091",
    "msp430c092",
    "msp430c111",
    "msp430c1111",
    "msp430c112",
    "msp430c1121",
    "msp430c1331",
    "msp430c1351",
    "msp430c311s",
    "msp430c312",
    "msp430c313",
    "msp430c314",
    "msp430c315",
    "msp430c323",
    "msp430c325",
    "msp430c336",
    "msp430c337",
    "msp430c412",
    "msp430c413",
    "msp430cg4616",
    "msp430cg4617",
    "msp430cg4618",
    "msp430cg4619",
    "msp430e112",
    "msp430e313",
    "msp430e315",
    "msp430e325",
    "msp430e337",
    "msp430f110",
    "msp430f1101",
    "msp430f1101a",
    "msp430f1111",
    "msp430f1111a",
    "msp430f112",
    "msp430f1121",
    "msp430f1121a",
    "msp430f1122",
    "msp430f1132",
    "msp430f122",
    "msp430f1222",
    "msp430f123",
    "msp430f1232",
    "msp430f133",
    "msp430f135",
    "msp430f147",
    "msp430f1471",
    "msp430f148",
    "msp430f1481",
    "msp430f149",
    "msp430f1491",
    "msp430f155",
    "msp430f156",
    "msp430f157",
    "msp430f1610",
    "msp430f1611",
    "msp430f1612",
    "msp430f167",
    "msp430f168",
    "msp430f169",
    "msp430f2001",
    "msp430f2002",
    "msp430f2003",
    "msp430f2011",
    "msp430f2012",
    "msp430f2013",
    "msp430f2101",
    "msp430f2111",
    "msp430f2112",
    "msp430f2121",
    "msp430f2122",
    "msp430f2131",
    "msp430f2132",
    "msp430f2232",
    "msp430f2234",
    "msp430f2252",
    "msp430f2254",
    "msp430f2272",
    "msp430f2274",
    "msp430f233",
    "msp430f2330",
    "msp430f235",
    "msp430f2350",
    "msp430f2370",
    "msp430f2410",
    "msp430f2416",
    "msp430f2417",
    "msp430f2418",
    "msp430f2419",
    "msp430f247",
    "msp430f2471",
    "msp430f248",
    "msp430f2481",
    "msp430f249",
    "msp430f2491",
    "msp430f2616",
    "msp430f2617",
    "msp430f2618",
    "msp430f2619",
    "msp430f412",
    "msp430f413",
    "msp430f4132",
    "msp430f415",
    "msp430f4152",
    "msp430f417",
    "msp430f423",
    "msp430f423a",
    "msp430f425",
    "msp430f4250",
    "msp430f425a",
    "msp430f4260",
    "msp430f427",
    "msp430f4270",
    "msp430f427a",
    "msp430f435",
    "msp430f4351",
    "msp430f436",
    "msp430f4361",
    "msp430f437",
    "msp430f4371",
    "msp430f438",
    "msp430f439",
    "msp430f447",
    "msp430f448",
    "msp430f4481",
    "msp430f449",
    "msp430f4491",
    "msp430f4616",
    "msp430f46161",
    "msp430f4617",
    "msp430f46171",
    "msp430f4618",
    "msp430f46181",
    "msp430f4619",
    "msp430f46191",
    "msp430f47126",
    "msp430f47127",
    "msp430f47163",
    "msp430f47166",
    "msp430f47167",
    "msp430f47173",
    "msp430f47176",
    "msp430f47177",
    "msp430f47183",
    "msp430f47186",
    "msp430f47187",
    "msp430f47193",
    "msp430f47196",
    "msp430f47197",
    "msp430f477",
    "msp430f478",
    "msp430f4783",
    "msp430f4784",
    "msp430f479",
    "msp430f4793",
    "msp430f4794",
    "msp430f5131",
    "msp430f5132",
    "msp430f5151",
    "msp430f5152",
    "msp430f5171",
    "msp430f5172",
    "msp430f5212",
    "msp430f5213",
    "msp430f5214",
    "msp430f5217",
    "msp430f5218",
    "msp430f5219",
    "msp430f5222",
    "msp430f5223",
    "msp430f5224",
    "msp430f5227",
    "msp430f5228",
    "msp430f5229",
    "msp430f5232",
    "msp430f5234",
    "msp430f5237",
    "msp430f5239",
    "msp430f5242",
    "msp430f5244",
    "msp430f5247",
    "msp430f5249",
    "msp430f5252",
    "msp430f5253",
    "msp430f5254",
    "msp430f5255",
    "msp430f5256",
    "msp430f5257",
    "msp430f5258",
    "msp430f5259",
    "msp430f5304",
    "msp430f5308",
    "msp430f5309",
    "msp430f5310",
    "msp430f5324",
    "msp430f5325",
    "msp430f5326",
    "msp430f5327",
    "msp430f5328",
    "msp430f5329",
    "msp430f5333",
    "msp430f5335",
    "msp430f5336",
    "msp430f5338",
    "msp430f5340",
    "msp430f5341",
    "msp430f5342",
    "msp430f5358",
    "msp430f5359",
    "msp430f5418",
    "msp430f5418a",
    "msp430f5419",
    "msp430f5419a",
    "msp430f5435",
    "msp430f5435a",
    "msp430f5436",
    "msp430f5436a",
    "msp430f5437",
    "msp430f5437a",
    "msp430f5438",
    "msp430f5438a",
    "msp430f5500",
    "msp430f5501",
    "msp430f5502",
    "msp430f5503",
    "msp430f5504",
    "msp430f5505",
    "msp430f5506",
    "msp430f5507",
    "msp430f5508",
    "msp430f5509",
    "msp430f5510",
    "msp430f5513",
    "msp430f5514",
    "msp430f5515",
    "msp430f5517",
    "msp430f5519",
    "msp430f5521",
    "msp430f5522",
    "msp430f5524",
    "msp430f5525",
    "msp430f5526",
    "msp430f5527",
    "msp430f5528",
    "msp430f5529",
    "msp430f5630",
    "msp430f5631",
    "msp430f5632",
    "msp430f5633",
    "msp430f5634",
    "msp430f5635",
    "msp430f5636",
    "msp430f5637",
    "msp430f5638",
    "msp430f5658",
    "msp430f5659",
    "msp430f6433",
    "msp430f6435",
    "msp430f6436",
    "msp430f6438",
    "msp430f6458",
    "msp430f6459",
    "msp430f6630",
    "msp430f6631",
    "msp430f6632",
    "msp430f6633",
    "msp430f6634",
    "msp430f6635",
    "msp430f6636",
    "msp430f6637",
    "msp430f6638",
    "msp430f6658",
    "msp430f6659",
    "msp430f6720",
    "msp430f6720a",
    "msp430f6721",
    "msp430f6721a",
    "msp430f6723",
    "msp430f6723a",
    "msp430f6724",
    "msp430f6724a",
    "msp430f6725",
    "msp430f6725a",
    "msp430f6726",
    "msp430f6726a",
    "msp430f6730",
    "msp430f6730a",
    "msp430f6731",
    "msp430f6731a",
    "msp430f6733",
    "msp430f6733a",
    "msp430f6734",
    "msp430f6734a",
    "msp430f6735",
    "msp430f6735a",
    "msp430f6736",
    "msp430f6736a",
    "msp430f6745",
    "msp430f67451",
    "msp430f67451a",
    "msp430f6745a",
    "msp430f6746",
    "msp430f67461",
    "msp430f67461a",
    "msp430f6746a",
    "msp430f6747",
    "msp430f67471",
    "msp430f67471a",
    "msp430f6747a",
    "msp430f6748",
    "msp430f67481",
    "msp430f67481a",
    "msp430f6748a",
    "msp430f6749",
    "msp430f67491",
    "msp430f67491a",
    "msp430f6749a",
    "msp430f67621",
    "msp430f67621a",
    "msp430f67641",
    "msp430f67641a",
    "msp430f6765",
    "msp430f67651",
    "msp430f67651a",
    "msp430f6765a",
    "msp430f6766",
    "msp430f67661",
    "msp430f67661a",
    "msp430f6766a",
    "msp430f6767",
    "msp430f67671",
    "msp430f67671a",
    "msp430f6767a",
    "msp430f6768",
    "msp430f67681",
    "msp430f67681a",
    "msp430f6768a",
    "msp430f6769",
    "msp430f67691",
    "msp430f67691a",
    "msp430f6769a",
    "msp430f6775",
    "msp430f67751",
    "msp430f67751a",
    "msp430f6775a",
    "msp430f6776",
    "msp430f67761",
    "msp430f67761a",
    "msp430f6776a",
    "msp430f6777",
    "msp430f67771",
    "msp430f67771a",
    "msp430f6777a",
    "msp430f6778",
    "msp430f67781",
    "msp430f67781a",
    "msp430f6778a",
    "msp430f6779",
    "msp430f67791",
    "msp430f67791a",
    "msp430f6779a",
    "msp430fe423",
    "msp430fe4232",
    "msp430fe423a",
    "msp430fe4242",
    "msp430fe425",
    "msp430fe4252",
    "msp430fe425a",
    "msp430fe427",
    "msp430fe4272",
    "msp430fe427a",
    "msp430fg4250",
    "msp430fg4260",
    "msp430fg4270",
    "msp430fg437",
    "msp430fg438",
    "msp430fg439",
    "msp430fg4616",
    "msp430fg4617",
    "msp430fg4618",
    "msp430fg4619",
    "msp430fg477",
    "msp430fg478",
    "msp430fg479",
    "msp430fg6425",
    "msp430fg6426",
    "msp430fg6625",
    "msp430fg6626",
    "msp430fr2000",
    "msp430fr2032",
    "msp430fr2033",
    "msp430fr2100",
    "msp430fr2110",
    "msp430fr2111",
    "msp430fr2153",
    "msp430fr2155",
    "msp430fr2310",
    "msp430fr2311",
    "msp430fr2353",
    "msp430fr2355",
    "msp430fr2422",
    "msp430fr2433",
    "msp430fr2475",
    "msp430fr2476",
    "msp430fr2512",
    "msp430fr2522",
    "msp430fr2532",
    "msp430fr2533",
    "msp430fr2632",
    "msp430fr2633",
    "msp430fr2672",
    "msp430fr2673",
    "msp430fr2675",
    "msp430fr2676",
    "msp430fr4131",
    "msp430fr4132",
    "msp430fr4133",
    "msp430fr5041",
    "msp430fr5043",
    "msp430fr50431",
    "msp430fr5720",
    "msp430fr5721",
    "msp430fr5722",
    "msp430fr5723",
    "msp430fr5724",
    "msp430fr5725",
    "msp430fr5726",
    "msp430fr5727",
    "msp430fr5728",
    "msp430fr5729",
    "msp430fr5730",
    "msp430fr5731",
    "msp430fr5732",
    "msp430fr5733",
    "msp430fr5734",
    "msp430fr5735",
    "msp430fr5736",
    "msp430fr5737",
    "msp430fr5738",
    "msp430fr5739",
    "msp430fr5847",
    "msp430fr58471",
    "msp430fr5848",
    "msp430fr5849",
    "msp430fr5857",
    "msp430fr5858",
    "msp430fr5859",
    "msp430fr5867",
    "msp430fr58671",
    "msp430fr5868",
    "msp430fr5869",
    "msp430fr5870",
    "msp430fr5872",
    "msp430fr58721",
    "msp430fr5887",
    "msp430fr5888",
    "msp430fr5889",
    "msp430fr58891",
    "msp430fr5922",
    "msp430fr59221",
    "msp430fr5947",
    "msp430fr59471",
    "msp430fr5948",
    "msp430fr5949",
    "msp430fr5957",
    "msp430fr5958",
    "msp430fr5959",
    "msp430fr5962",
    "msp430fr5964",
    "msp430fr5967",
    "msp430fr5968",
    "msp430fr5969",
    "msp430fr59691",
    "msp430fr5970",
    "msp430fr5972",
    "msp430fr59721",
    "msp430fr5986",
    "msp430fr5987",
    "msp430fr5988",
    "msp430fr5989",
    "msp430fr59891",
    "msp430fr5992",
    "msp430fr5994",
    "msp430fr59941",
    "msp430fr6005",
    "msp430fr6007",
    "msp430fr6035",
    "msp430fr6037",
    "msp430fr60371",
    "msp430fr6041",
    "msp430fr6043",
    "msp430fr60431",
    "msp430fr6045",
    "msp430fr6047",
    "msp430fr60471",
    "msp430fr6820",
    "msp430fr6822",
    "msp430fr68221",
    "msp430fr6870",
    "msp430fr6872",
    "msp430fr68721",
    "msp430fr6877",
    "msp430fr6879",
    "msp430fr68791",
    "msp430fr6887",
    "msp430fr6888",
    "msp430fr6889",
    "msp430fr68891",
    "msp430fr6920",
    "msp430fr6922",
    "msp430fr69221",
    "msp430fr6927",
    "msp430fr69271",
    "msp430fr6928",
    "msp430fr6970",
    "msp430fr6972",
    "msp430fr69721",
    "msp430fr6977",
    "msp430fr6979",
    "msp430fr69791",
    "msp430fr6987",
    "msp430fr6988",
    "msp430fr6989",
    "msp430fr69891",
    "msp430fw423",
    "msp430fw425",
    "msp430fw427",
    "msp430fw428",
    "msp430fw429",
    "msp430g2001",
    "msp430g2101",
    "msp430g2102",
    "msp430g2111",
    "msp430g2112",
    "msp430g2113",
    "msp430g2121",
    "msp430g2131",
    "msp430g2132",
    "msp430g2152",
    "msp430g2153",
    "msp430g2201",
    "msp430g2202",
    "msp430g2203",
    "msp430g2210",
    "msp430g2211",
    "msp430g2212",
    "msp430g2213",
    "msp430g2221",
    "msp430g2230",
    "msp430g2231",
    "msp430g2232",
    "msp430g2233",
    "msp430g2252",
    "msp430g2253",
    "msp430g2302",
    "msp430g2303",
    "msp430g2312",
    "msp430g2313",
    "msp430g2332",
    "msp430g2333",
    "msp430g2352",
    "msp430g2353",
    "msp430g2402",
    "msp430g2403",
    "msp430g2412",
    "msp430g2413",
    "msp430g2432",
    "msp430g2433",
    "msp430g2444",
    "msp430g2452",
    "msp430g2453",
    "msp430g2513",
    "msp430g2533",
    "msp430g2544",
    "msp430g2553",
    "msp430g2744",
    "msp430g2755",
    "msp430g2855",
    "msp430g2955",
    "msp430i2020",
    "msp430i2021",
    "msp430i2030",
    "msp430i2031",
    "msp430i2040",
    "msp430i2041",
    "msp430l092",
    "msp430p112",
    "msp430p313",
    "msp430p315",
    "msp430p315s",
    "msp430p325",
    "msp430p337",
    "msp430sl5438a",
    "msp430tch5e",
    "rf430f5144",
    "rf430f5155",
    "rf430f5175",
    "rf430frl152h",
    "rf430frl153h",
    "rf430frl154h",
];
