//! RAMCTL

utils::periph! {
    /// RAMCTL
    RAMCTL;
    /// RAM Controller Control 0
    rw RCCTL0 @ 0x00: u16 = 0_0 {
        /// RAM controller RAM sector 0 off
        RCRS0OFF: 0..1 = enum RCRS0OFF {
            /// Contents of this RAM sector are retained in LPM3 and LPM4.
            RCRS0OFF_0 = 0b00,
            /// Turns off this RAM sector in LPM3 and LPM4, re-activates it on wake-up. All data of this RAM sector is lost after wakeup from LPM3 and LPM4. See the device-specific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_1 = 0b01,
            /// Turns off this RAM sector entering LPM3 and LPM4, the RAM sector remains off after wake-up. All data of this RAM sector is lost. See the devicespecific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_2 = 0b10,
        }
        /// RAM controller key. Always reads as 69h. Must be written as 5Ah; any other write is is ignored.
        RCKEY: 8..15 = struct RCKEY(u16);
        /// RAM controller RAM sector 0 off
        RCRS1OFF: 2..3 = enum RCRS1OFF {
            /// Contents of this RAM sector are retained in LPM3 and LPM4.
            RCRS0OFF_0 = 0b00,
            /// Turns off this RAM sector in LPM3 and LPM4, re-activates it on wake-up. All data of this RAM sector is lost after wakeup from LPM3 and LPM4. See the device-specific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_1 = 0b01,
            /// Turns off this RAM sector entering LPM3 and LPM4, the RAM sector remains off after wake-up. All data of this RAM sector is lost. See the devicespecific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_2 = 0b10,
        }
        /// RAM controller RAM sector 3 off
        RCRS3OFF: 6..7 = enum RCRS3OFF {
            /// Contents of this RAM sector are retained in LPM3 and LPM4.
            RCRS0OFF_0 = 0b00,
            /// Turns off this RAM sector in LPM3 and LPM4, re-activates it on wake-up. All data of this RAM sector is lost after wakeup from LPM3 and LPM4. See the device-specific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_1 = 0b01,
            /// Turns off this RAM sector entering LPM3 and LPM4, the RAM sector remains off after wake-up. All data of this RAM sector is lost. See the devicespecific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_2 = 0b10,
        }
        /// RAM controller RAM sector 0 off
        RCRS2OFF: 4..5 = enum RCRS2OFF {
            /// Contents of this RAM sector are retained in LPM3 and LPM4.
            RCRS0OFF_0 = 0b00,
            /// Turns off this RAM sector in LPM3 and LPM4, re-activates it on wake-up. All data of this RAM sector is lost after wakeup from LPM3 and LPM4. See the device-specific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_1 = 0b01,
            /// Turns off this RAM sector entering LPM3 and LPM4, the RAM sector remains off after wake-up. All data of this RAM sector is lost. See the devicespecific data sheet to find the number of available sectors, the address range, and the size of each RAM sector.
            RCRS0OFF_2 = 0b10,
        }
    }
}
