use anyhow::Result;
use rasn_cms::{ContentInfo, SignedData, CONTENT_SIGNED_DATA};
use std::fs::File;
use std::io::{BufReader, Read};
use std::path::Path;

pub const SZOID_CTL: ConstOid = ConstOid(&[1, 3, 6, 2, 4, 1, 311, 10, 1]);

pub fn read_cms(path: &Path) -> Result<()> {
    let f = File::open(path)?;
    let mut r = BufReader::new(f);
    let mut der = vec![];
    r.read_to_end(&mut der)?;
    let info = rasn::der::decode::<ContentInfo>(&der).map_err(|err| anyhow::anyhow!("{}", err))?;
    anyhow::ensure!(CONTENT_SIGNED_DATA == info.content_type);
    let data = rasn::der::decode::<SignedData>(info.content.as_bytes())
        .map_err(|err| anyhow::anyhow!("{}", err))?;
    println!("{:#?}", data);
    Ok(())
}

#[cfg(test)]
mod tests {
    //use super::*;

    #[test]
    #[ignore]
    fn decode_szoid() {
        let szoid = [
            //160, 130, 5, 23,
            48, 130, 5, 19, 48, 12, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 1, 1, 4, 16, 41, 0, 84, 108,
            42, 182, 163, 79, 128, 120, 76, 25, 236, 79, 84, 230, 23, 13, 50, 49, 49, 50, 50, 55,
            49, 53, 50, 50, 48, 52, 90, 48, 14, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 1, 3, 5, 0, 48,
            130, 4, 152, 48, 129, 149, 4, 32, 23, 59, 29, 29, 173, 59, 4, 226, 70, 23, 197, 154,
            238, 15, 24, 62, 159, 57, 208, 68, 124, 20, 21, 178, 101, 208, 200, 208, 219, 14, 124,
            10, 49, 113, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 93,
            6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 4, 49, 79, 48, 77, 48, 24, 6, 10, 43, 6, 1, 4, 1,
            130, 55, 2, 1, 15, 48, 10, 3, 2, 5, 160, 160, 4, 162, 2, 128, 0, 48, 49, 48, 13, 6, 9,
            96, 134, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32, 23, 59, 29, 29, 173, 59, 4, 226, 70, 23,
            197, 154, 238, 15, 24, 62, 159, 57, 208, 68, 124, 20, 21, 178, 101, 208, 200, 208, 219,
            14, 124, 10, 48, 42, 4, 20, 27, 246, 190, 100, 174, 49, 38, 231, 84, 245, 168, 11, 201,
            1, 147, 44, 62, 143, 136, 142, 49, 18, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 2,
            3, 49, 2, 128, 0, 48, 129, 149, 4, 32, 35, 187, 171, 145, 233, 190, 227, 234, 53, 25,
            146, 152, 135, 244, 65, 67, 184, 166, 232, 2, 163, 215, 68, 64, 43, 165, 152, 96, 40,
            209, 209, 47, 49, 113, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0,
            48, 93, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 4, 49, 79, 48, 77, 48, 24, 6, 10, 43, 6,
            1, 4, 1, 130, 55, 2, 1, 15, 48, 10, 3, 2, 5, 160, 160, 4, 162, 2, 128, 0, 48, 49, 48,
            13, 6, 9, 96, 134, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32, 35, 187, 171, 145, 233, 190,
            227, 234, 53, 25, 146, 152, 135, 244, 65, 67, 184, 166, 232, 2, 163, 215, 68, 64, 43,
            165, 152, 96, 40, 209, 209, 47, 48, 42, 4, 20, 43, 107, 183, 163, 78, 239, 219, 150,
            184, 69, 184, 229, 121, 151, 97, 124, 149, 169, 92, 108, 49, 18, 48, 16, 6, 10, 43, 6,
            1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 42, 4, 20, 46, 238, 101, 77, 17, 231,
            70, 32, 192, 53, 185, 47, 81, 251, 4, 8, 86, 141, 17, 105, 49, 18, 48, 16, 6, 10, 43,
            6, 1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 129, 149, 4, 32, 64, 185, 18, 38, 60,
            99, 174, 238, 90, 23, 20, 5, 202, 66, 158, 247, 140, 252, 199, 63, 144, 221, 189, 200,
            190, 211, 95, 75, 118, 136, 193, 254, 49, 113, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55,
            12, 2, 3, 49, 2, 128, 0, 48, 93, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 4, 49, 79, 48,
            77, 48, 24, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 15, 48, 10, 3, 2, 5, 160, 160, 4,
            162, 2, 128, 0, 48, 49, 48, 13, 6, 9, 96, 134, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32, 64,
            185, 18, 38, 60, 99, 174, 238, 90, 23, 20, 5, 202, 66, 158, 247, 140, 252, 199, 63,
            144, 221, 189, 200, 190, 211, 95, 75, 118, 136, 193, 254, 48, 129, 149, 4, 32, 73, 234,
            241, 118, 0, 254, 241, 219, 181, 83, 17, 154, 64, 138, 211, 196, 24, 21, 129, 255, 33,
            50, 184, 202, 108, 128, 195, 154, 211, 152, 194, 196, 49, 113, 48, 16, 6, 10, 43, 6, 1,
            4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 93, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1,
            4, 49, 79, 48, 77, 48, 24, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 15, 48, 10, 3, 2, 5,
            160, 160, 4, 162, 2, 128, 0, 48, 49, 48, 13, 6, 9, 96, 134, 72, 1, 101, 3, 4, 2, 1, 5,
            0, 4, 32, 73, 234, 241, 118, 0, 254, 241, 219, 181, 83, 17, 154, 64, 138, 211, 196, 24,
            21, 129, 255, 33, 50, 184, 202, 108, 128, 195, 154, 211, 152, 194, 196, 48, 129, 149,
            4, 32, 83, 158, 103, 27, 242, 153, 69, 146, 81, 55, 146, 6, 168, 149, 180, 132, 58,
            114, 196, 119, 75, 23, 54, 148, 137, 64, 19, 67, 72, 175, 128, 88, 49, 113, 48, 16, 6,
            10, 43, 6, 1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 93, 6, 10, 43, 6, 1, 4, 1,
            130, 55, 2, 1, 4, 49, 79, 48, 77, 48, 24, 6, 10, 43, 6, 1, 4, 1, 130, 55, 2, 1, 15, 48,
            10, 3, 2, 5, 160, 160, 4, 162, 2, 128, 0, 48, 49, 48, 13, 6, 9, 96, 134, 72, 1, 101, 3,
            4, 2, 1, 5, 0, 4, 32, 83, 158, 103, 27, 242, 153, 69, 146, 81, 55, 146, 6, 168, 149,
            180, 132, 58, 114, 196, 119, 75, 23, 54, 148, 137, 64, 19, 67, 72, 175, 128, 88, 48,
            129, 149, 4, 32, 126, 10, 126, 72, 107, 252, 100, 155, 72, 100, 190, 139, 194, 17, 163,
            216, 237, 136, 59, 64, 191, 129, 21, 173, 232, 235, 109, 92, 212, 199, 230, 241, 49,
            113, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 93, 6, 10,
            43, 6, 1, 4, 1, 130, 55, 2, 1, 4, 49, 79, 48, 77, 48, 24, 6, 10, 43, 6, 1, 4, 1, 130,
            55, 2, 1, 15, 48, 10, 3, 2, 5, 160, 160, 4, 162, 2, 128, 0, 48, 49, 48, 13, 6, 9, 96,
            134, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32, 126, 10, 126, 72, 107, 252, 100, 155, 72,
            100, 190, 139, 194, 17, 163, 216, 237, 136, 59, 64, 191, 129, 21, 173, 232, 235, 109,
            92, 212, 199, 230, 241, 48, 42, 4, 20, 154, 240, 3, 223, 34, 0, 65, 167, 139, 180, 67,
            62, 91, 4, 105, 135, 121, 137, 28, 70, 49, 18, 48, 16, 6, 10, 43, 6, 1, 4, 1, 130, 55,
            12, 2, 3, 49, 2, 128, 0, 48, 42, 4, 20, 214, 41, 114, 96, 206, 145, 15, 35, 158, 175,
            204, 119, 170, 165, 18, 129, 227, 60, 213, 73, 49, 18, 48, 16, 6, 10, 43, 6, 1, 4, 1,
            130, 55, 12, 2, 3, 49, 2, 128, 0, 48, 42, 4, 20, 215, 124, 170, 253, 41, 139, 139, 9,
            185, 131, 127, 37, 81, 37, 47, 129, 23, 234, 16, 119, 49, 18, 48, 16, 6, 10, 43, 6, 1,
            4, 1, 130, 55, 12, 2, 3, 49, 2, 128, 0, 160, 54, 48, 52, 48, 50, 6, 10, 43, 6, 1, 4, 1,
            130, 55, 12, 2, 1, 4, 36, 48, 34, 30, 12, 0, 79, 0, 83, 0, 65, 0, 116, 0, 116, 0, 114,
            2, 4, 16, 1, 0, 1, 4, 12, 50, 0, 58, 0, 54, 0, 46, 0, 50, 0, 0, 0,
        ];
        let (rem, res) = der_parser::parse_der(&szoid).unwrap();
        assert!(rem.is_empty());
        println!("{:#?}", res);
        assert!(false);
    }
}
