use ms_toollib::{refresh_matrixs};
#[macro_use]
extern crate bencher;
use bencher::Bencher;

// 测试计算矩阵性能
// cargo bench --bench refresh_matrix
fn bench_sample_3BVs_exp(bencher: &mut Bencher) {
    let game_board = vec![
        vec![10, 10, 10,  1,  1,  0,  0,  1, 11,  1,  0,  0,  0,  0,  1, 10, 10, 10,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 11,  2,  0,  0,  1,  1,  1,  1,  2,  2,  1,  1, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 11,  4,  2,  1,  0,  0,  0,  1, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 11, 11,  2,  1,  0,  0,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 11,  3,  1,  1,  1, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  5, 10,  4, 10,  3, 10,  2, 10,  1, 10,  0, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10,  2,  2,  4, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        vec![10, 10,  1,  0,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0,  0,  0, 10, 10, 10, 10],
        vec![ 1,  1,  1,  1,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0, 10,  0, 10, 10, 10, 10],
        vec![ 0,  0,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,  0,  0,  0, 10, 10, 10, 10],
        vec![ 0,  0,  2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
    ];
    bencher.iter(|| refresh_matrixs(&game_board));
} // 15,048 ns/iter

benchmark_group!(refresh_matrix, bench_sample_3BVs_exp);
benchmark_main!(refresh_matrix);
