//! # 扫雷算法工具箱
//! 提供扫雷相关算法的rust实现，并发布到各个平台

mod utils;
pub use utils::{
    cal3BV, calOp, cal_table_minenum_recursion, combine, lay_mine_number, lay_mine_op_number,
    refreshBoard, refresh_matrix, refresh_matrixs, unsolvableStructure,
};

mod algorithms;
#[cfg(any(feature = "py", feature = "rs"))]
pub use algorithms::{layMineSolvable_thread, sample_3BVs_exp, OBR_board};
// #[cfg(feature = "js")]
pub use algorithms::{
    cal_is_op_possibility_cells, cal_possibility, cal_possibility_onboard, isSolvable, layMine,
    layMineOp, layMineSolvable, mark_board, SolveDirect, SolveEnumerate, SolveMinus,
};

mod board;
pub use board::MinesweeperBoard;
#[cfg(any(feature = "py", feature = "rs"))]
mod OBR;
#[cfg(any(feature = "py", feature = "rs"))]
pub use OBR::ImageBoard;



