pub mod cancel;
pub mod choose;
pub mod close;
pub mod fork;
pub mod meshedchannels;
pub mod offer;
pub mod recv;
pub mod send;

/// Creates the structure MeshedChannels
/// [`create_meshedchannels`],
/// the [`close_mpst`] and [`fork_mpst_multi`].
///
/// # Arguments
///
/// * The name of the new *close* function
/// * The name of the new *fork* function
/// * The name of the *MeshedChannels* type that will be used
/// * The number of participants (all together)
///
/// # Example
///
/// ```
/// use mpstthree::bundle_struct_fork_close_multi;
///
/// bundle_struct_fork_close_multi!(close_mpst, fork_mpst, MeshedChannels, 3);
/// ```
///
/// [`create_meshedchannels`]: crate::create_meshedchannels
/// [`close_mpst`]: crate::close_mpst
/// [`fork_mpst_multi`]: crate::fork_mpst_multi
#[macro_export]
macro_rules! bundle_struct_fork_close_multi {
    ($func_name_close: ident, $func_name_fork: ident, $meshedchannels_name: ident, $nsessions: literal) => {
        mpstthree::create_meshedchannels!($meshedchannels_name, $nsessions);
        mpstthree::close_mpst!($func_name_close, $meshedchannels_name, $nsessions);
        mpstthree::fork_mpst_multi!($func_name_fork, $meshedchannels_name, $nsessions);
    };
}

/// Creates the structure MeshedChannels
/// [`create_meshedchannels`],
/// the [`close_mpst_cancel`] and
/// [`fork_mpst_multi`]
/// functions to be used with more than 2 participants.
/// It checks the send sides of the channels along the recv sides.
///
/// # Arguments
///
/// * The name of the new *close* function
/// * The name of the new *fork* function
/// * The name of the *MeshedChannels* type that will be used
/// * The number of participants (all together)
///
/// # Example
///
/// ```
/// use mpstthree::bundle_struct_fork_close_multi_cancel;
///
/// bundle_struct_fork_close_multi_cancel!(close_mpst, fork_mpst, MeshedChannels, 3);
/// ```
///
/// [`create_meshedchannels`]: crate::create_meshedchannels
/// [`close_mpst_cancel`]: crate::close_mpst_cancel
/// [`fork_mpst_multi`]: crate::fork_mpst_multi
#[macro_export]
macro_rules! bundle_struct_fork_close_multi_cancel {
    ($func_name_close: ident, $func_name_fork: ident, $meshedchannels_name: ident, $nsessions: literal) => {
        mpstthree::create_meshedchannels!($meshedchannels_name, $nsessions);
        mpstthree::close_mpst_cancel!($func_name_close, $meshedchannels_name, $nsessions);
        mpstthree::fork_mpst_multi!($func_name_fork, $meshedchannels_name, $nsessions);
    };
}
