use crate::client::MpesaResult;

/// Trait responsible for implementation of security configs for Mpesa
pub trait MpesaSecurity {
    /// Generates security credentials
    /// M-Pesa Core authenticates a transaction by decrypting the security credentials.
    /// Security credentials are generated by encrypting the base64 encoded initiator password with M-Pesa’s public key, a X509 certificate.
    /// Returns base64 encoded string.
    ///
    /// # Error
    /// Returns `EncryptionError` variant of `MpesaError`
    fn gen_security_credentials(&self) -> MpesaResult<String>;
}
