use crate::{model::PlaylistsModel, util::ui_util, AppBackend, ThemeConfig};

use mpd::Playlist;
use tui::{
    layout::{Constraint, Rect},
    style::{Modifier, Style},
    terminal::Frame,
    widgets::{Row, Table},
};

pub fn view(
    playlists: &mut PlaylistsModel,
    theme: &ThemeConfig,
    f: &mut Frame<AppBackend>,
    area: Rect,
) {
    let items = playlists.items.items.iter().map(|list| {
        let lines = parse_list(&list).into_iter();
        Row::Data(lines)
    });
    let items = Table::new(vec!["  Name"].into_iter(), items)
        .style(ui_util::table_style(&theme))
        .block(ui_util::create_content_frame(&theme, "Playlists".into()))
        .highlight_style(Style::default().add_modifier(Modifier::BOLD))
        .highlight_symbol("→ ")
        .widths(&[Constraint::Percentage(100)]);

    f.render_stateful_widget(items, area, &mut playlists.items.state);
}

fn parse_list(list: &Playlist) -> Vec<String> {
    vec![list.name.clone()]
}
