use crate::{data_types::*, model::Model, App};
use termion::event::Key;

#[derive(Debug, Clone)]
pub struct InputModel {
    pub buffer: String,
    pub name: String,
    pub return_msg: Message,
}

impl Default for InputModel {
    fn default() -> Self {
        Self::new()
    }
}

impl InputModel {
    pub fn new() -> Self {
        Self {
            buffer: String::new(),
            name: String::new(),
            return_msg: Message::None,
        }
    }

    pub fn handle_message(&mut self, name: &str, message: &Message) {
        self.name = name.into();
        self.buffer = "".into();
        self.return_msg = message.clone();
    }
}

pub fn stop_input(model: &mut Model) {
    model.input.name = "".into();
    model.input.buffer = "".into();
    model.input_state = InputState::KeyCommands;
}

pub fn handle_event(app: &App, key: &Key) {
    let model = &mut app.model();

    match key {
        Key::Char('\n') => {
            let message = model
                .input
                .return_msg
                .replace_selector(Selector::Text(model.input.buffer.clone()));
            app.send_message(message);
            stop_input(model);
        }
        Key::Char(c) => model.input.buffer.push(*c),
        Key::Backspace => {
            model.input.buffer.pop();
        }
        Key::Esc => stop_input(model),
        _ => {}
    }
}
