use crate::{
    model::LibraryModel,
    util::ui_util,
    AppBackend, ThemeConfig,
};

use tui::{
    layout::{Constraint, Rect},
    style::{Modifier, Style},
    terminal::Frame,
    widgets::{Row, Table},
};

pub fn view(
    library: &mut LibraryModel,
    theme: &ThemeConfig,
    f: &mut Frame<AppBackend>,
    area: Rect,
) {
    let items = library.items.items.iter().map(|text| {
        let lines = vec![text].into_iter();
        Row::Data(lines)
    });
    let items = Table::new(vec!["  Name"].into_iter(), items)
        .style(ui_util::table_style(&theme))
        .block(ui_util::create_content_frame(&theme, library.get_title()))
        .highlight_style(Style::default().add_modifier(Modifier::BOLD))
        .highlight_symbol("→ ")
        .widths(&[Constraint::Percentage(100)]);

    f.render_stateful_widget(items, area, &mut library.items.state);
}
