use serde::{Deserialize, Serialize};
use strum_macros::EnumIter;

pub use crate::model::TabContent;

#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, EnumIter, Serialize, Deserialize)]
pub enum Context {
    Global,
    List,
    Queue,
    Playlists,
    Library,
    Volume,
}

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub enum Message {
    TogglePause,
    NextTab,
    PrevTab,
    SetTab(TabContent),
    MoveUp,
    MoveDown,
    MoveFirst,
    MoveLast,
    Play,
    ListExpand,
    ListCollapse,

    ChangeVolume(i32),
    SetVolume(i32),

    Rescan,
    Seek(i32),

    UpdatePlayer,
    UpdateLibrary,
    UpdateQueue,
    UpdatePlaylists,
    UpdateVolume,

    None,
    Quit,
}

#[derive(Debug)]
pub enum InputState {
    TextInput,
    None,
}
