use crate::{util::ui_util::StatefulTable, App};
use mpd::Song;

#[derive(Debug, Clone)]
pub struct QueueModel {
    pub items: StatefulTable<Song>,
    pub current_song: Option<Song>,
}

impl Default for QueueModel {
    fn default() -> Self {
        Self::new()
    }
}

impl QueueModel {
    pub fn new() -> Self {
        Self {
            items: StatefulTable::new(),
            current_song: None,
        }
    }
}

pub fn play(app: &App) {
    let selected = app.model().queue.items.state.selected();

    // Lock on model is released, so we can lock connection
    selected.and_then(|s| app.connection().switch(s as u32).ok());
}

pub fn update(app: &App) {
    let (items, current_song) = {
        let mut connection = app.connection();
        let items = StatefulTable::with_items(connection.queue().unwrap_or_else(|_| Vec::new()));
        let current_song = connection.currentsong().ok().and_then(|s| s);
        (items, current_song)
    };

    let queue = &mut app.model().queue;
    queue.items = items;
    queue.current_song = current_song;
    queue.items.state.select(
        queue
            .current_song
            .clone()
            .and_then(|s| s.place)
            .map(|p| p.pos as usize),
    );
}
