use crate::{model::PlaylistsModel, AppBackend};

use mpd::Playlist;
use tui::{
    layout::{Constraint, Rect},
    style::{Color, Modifier, Style},
    terminal::Frame,
    widgets::{Block, Borders, Row, Table},
};

pub fn view(playlists: &mut PlaylistsModel, f: &mut Frame<AppBackend>, area: Rect) {
    let items = playlists.items.items.iter().map(|list| {
        let lines = parse_list(&list).into_iter();
        Row::Data(lines)
    });
    let items = Table::new(vec!["  Name"].into_iter(), items)
        .block(
            Block::default()
                .title("Playlists")
                .borders(Borders::ALL)
                .style(Style::default().fg(Color::Cyan)),
        )
        .highlight_style(Style::default().add_modifier(Modifier::BOLD))
        .highlight_symbol("→ ")
        .widths(&[Constraint::Percentage(100)]);

    f.render_stateful_widget(items, area, &mut playlists.items.state);
}

fn parse_list(list: &Playlist) -> Vec<String> {
    vec![list.name.clone()]
}
