use crate::{util::ui_util::StatefulTable, App};
use mpd::Playlist;

#[derive(Debug, Clone)]
pub struct PlaylistsModel {
    pub items: StatefulTable<Playlist>,
}

impl Default for PlaylistsModel {
    fn default() -> Self {
        Self::new()
    }
}

impl PlaylistsModel {
    pub fn new() -> Self {
        Self {
            items: StatefulTable::new(),
        }
    }
}

pub fn play(app: &App) {
    let mut connection = app.connection();

    connection
        .clear()
        .ok()
        .and_then(|_| app.model().playlists.items.state.selected())
        .and_then(|index| app.model().playlists.items.items.get(index).cloned())
        .and_then(|playlist| connection.load(playlist, ..).ok())
        .and_then(|_| connection.play().ok());
}

pub fn update(app: &App) {
    let playlists = app.connection().playlists();

    app.model().playlists.items =
        StatefulTable::with_items(playlists.unwrap_or_else(|_| Vec::new()));
}
