use mpd::Subsystem;
use serde::{Deserialize, Serialize};
use strum_macros::EnumIter;

pub use crate::model::TabContent;

#[derive(Debug, Clone, Copy, PartialEq, Eq, Hash, EnumIter, Serialize, Deserialize)]
pub enum Context {
    Global,
    List,
    Queue,
    Playlists,
    Library,
    Volume,
}

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub enum Message {
    TogglePause,
    NextTab,
    PrevTab,
    SetTab(TabContent),
    MoveUp,
    MoveDown,
    MoveFirst,
    MoveLast,
    Play,
    ListExpand,
    ListCollapse,
    VolumeUp,
    VolumeDown,

    UpdatePlayer,
    UpdateLibrary,
    UpdateQueue,
    UpdatePlaylists,
    UpdateVolume,

    None,
    Quit,
}

impl From<Subsystem> for Message {
    fn from(subsystem: Subsystem) -> Self {
        match subsystem {
            Subsystem::Player => Message::UpdatePlayer,
            Subsystem::Database => Message::UpdateLibrary,
            Subsystem::Mixer => Message::UpdateVolume,
            Subsystem::Playlist => Message::UpdatePlaylists,
            Subsystem::Queue => Message::UpdateQueue,
            _ => Message::None,
        }
    }
}

#[derive(Debug)]
pub enum InputState {
    TextInput,
    None,
}
