use crate::{model::ProgressBarModel, AppBackend};

use tui::{
    layout::Rect,
    style::{Color, Style},
    terminal::Frame,
    widgets::{Block, Borders, Gauge},
};

pub fn view(progress_bar: &ProgressBarModel, f: &mut Frame<AppBackend>, area: Rect) {
    let gauge = Gauge::default()
        .block(
            Block::default()
                .borders(Borders::ALL)
                .title(progress_bar.state())
                .style(Style::default().fg(Color::Cyan)),
        )
        .gauge_style(Style::default().fg(Color::Cyan).bg(Color::Black))
        .percent(progress_bar.get_progress());

    f.render_widget(gauge, area);
}
