use crate::{model::LibraryModel, AppBackend};

use tui::{
    layout::{Constraint, Rect},
    style::{Color, Modifier, Style},
    terminal::Frame,
    widgets::{Block, Borders, Row, Table},
};

pub fn view(library: &mut LibraryModel, f: &mut Frame<AppBackend>, area: Rect) {
    let items = library.items.items.iter().map(|text| {
        let lines = vec![text].into_iter();
        Row::Data(lines)
    });
    let items = Table::new(vec!["  Name"].into_iter(), items)
        .block(
            Block::default()
                .title(library.get_title())
                .borders(Borders::ALL)
                .style(Style::default().fg(Color::Cyan)),
        )
        .highlight_style(Style::default().add_modifier(Modifier::BOLD))
        .highlight_symbol("→ ")
        .widths(&[Constraint::Percentage(100)]);

    f.render_stateful_widget(items, area, &mut library.items.state);
}
