pub mod event;
pub mod ui_util;

#[macro_use]
pub mod log;

#[macro_use]
pub mod keys;

use crate::config::Config;
use mpd::Client;
use std::ops::{Deref, DerefMut};

pub struct MPDConnection<'a> {
    connection: Client,
    config: &'a Config,
}

impl<'a> MPDConnection<'a> {
    pub fn new(config: &'a Config) -> Self {
        Self {
            connection: Self::connect(config),
            config,
        }
    }

    fn connect(config: &Config) -> Client {
        Client::connect(format!("{}:{}", config.host, config.port)).unwrap()
    }
}

impl<'a> Deref for MPDConnection<'a> {
    type Target = Client;

    fn deref(&self) -> &Client {
        &self.connection
    }
}

impl<'a> DerefMut for MPDConnection<'a> {
    fn deref_mut(&mut self) -> &mut Client {
        if self.connection.ping().is_err() {
            self.connection = Self::connect(self.config);
        }

        &mut self.connection
    }
}
