use crate::{model::AppHandle, MPDConnection};

#[derive(Debug, Clone)]
pub struct VolumeModel {
    volume: i8,
}

impl Default for VolumeModel {
    fn default() -> Self {
        Self::new()
    }
}

impl VolumeModel {
    pub fn new() -> Self {
        Self { volume: 0 }
    }
}

fn update_state_volume(app: &AppHandle, status: mpd::Status) {
    app.model().volume.volume = status.volume;
}

pub fn update(app: &AppHandle, connection: &mut MPDConnection) {
    let _ = connection
        .status()
        .map(|status| update_state_volume(app, status));
}

fn set_volume(app: &AppHandle, connection: &mut MPDConnection, new_volume: i8) {
    if let Ok(()) = connection.volume(new_volume) {
        app.model().volume.volume = new_volume;
    }
}

pub fn change_volume(app: &AppHandle, connection: &mut MPDConnection, delta: i8) {
    let volume = app.model().volume.volume;
    set_volume(app, connection, volume + delta);
}
