use crate::{model::AppHandle, util::ui_util::StatefulTable, MPDConnection};
use mpd::Song;

#[derive(Debug, Clone)]
pub struct QueueModel {
    pub items: StatefulTable<Song>,
    pub current_song: Option<Song>,
}

impl Default for QueueModel {
    fn default() -> Self {
        Self::new()
    }
}

impl QueueModel {
    pub fn new() -> Self {
        Self {
            items: StatefulTable::new(),
            current_song: None,
        }
    }
}

pub fn play(app: &AppHandle, connection: &mut MPDConnection) {
    let selected = app.model().queue.items.state.selected();

    selected.and_then(|s| connection.switch(s as u32).ok());
}

pub fn update(app: &AppHandle, connection: &mut MPDConnection) {
    let items = StatefulTable::with_items(connection.queue().unwrap_or_else(|_| Vec::new()));
    let current_song = connection.currentsong().ok().and_then(|s| s);

    let queue = &mut app.model().queue;
    queue.items = items;
    queue.current_song = current_song;
    queue.items.state.select(
        queue
            .current_song
            .clone()
            .and_then(|s| s.place)
            .map(|p| p.pos as usize),
    );
}
