use crate::{model::AppHandle, util::ui_util::StatefulTable, MPDConnection};
use mpd::Playlist;

#[derive(Debug, Clone)]
pub struct PlaylistsModel {
    pub items: StatefulTable<Playlist>,
}

impl Default for PlaylistsModel {
    fn default() -> Self {
        Self::new()
    }
}

impl PlaylistsModel {
    pub fn new() -> Self {
        Self {
            items: StatefulTable::new(),
        }
    }
}

pub fn play(app: &AppHandle, connection: &mut MPDConnection) {
    connection
        .clear()
        .ok()
        .and_then(|_| app.model().playlists.items.state.selected())
        .and_then(|index| app.model().playlists.items.items.get(index).cloned())
        .and_then(|playlist| connection.load(playlist, ..).ok())
        .and_then(|_| connection.play().ok());
}

pub fn update(app: &AppHandle, connection: &mut MPDConnection) {
    let playlists = connection.playlists();

    app.model().playlists.items =
        StatefulTable::with_items(playlists.unwrap_or_else(|_| Vec::new()));
}
