//! # Art
//! 
//! A library for modeling artistic concepts.

// ---------- Imports ---------

pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;


// ---------- Implementation ----------

mod kinds {

    /// The primary color according to the RYB color model.
    pub enum PrimaryColor {
        Red,
        Yellow,
        Blue,
    }

    /// The secondary colors according to the RYB color model.
    pub enum SecondaryColor {
        Orange,
        Green,
        Purple,
    }
}

mod utils {
    use super::kinds::*;

    /// Combines two primary colors in equal amounts
    /// to create a secondary color.
    pub fn mix(_c1: PrimaryColor, _c2: PrimaryColor)  -> SecondaryColor {
        SecondaryColor::Green
    }
}