#ifndef MOSAIQ_SDK_VERSIONINFO_H
#define MOSAIQ_SDK_VERSIONINFO_H

#include "detail/preprocessor.h"

#ifdef __cplusplus
#  include <cstddef>
#else
#  include <stddef.h>
#endif

#ifdef __GLIBCPP__
#  define MOSAIQ_EXPORT_GLIBCPP_VERSION \
    DLL_EXPORT char const* mosaiq_glibcpp_version() { return MOSAIQ_SDK_STRINGIZE(__GLIBCPP__); };
#else
#  define MOSAIQ_EXPORT_GLIBCPP_VERSION \
    DLL_EXPORT char const* mosaiq_glibcpp_version() { return ""; };
#endif

#ifdef __GLIBCXX__
#  define MOSAIQ_EXPORT_GLIBCXX_VERSION \
    DLL_EXPORT char const* mosaiq_glibcxx_version() { return MOSAIQ_SDK_STRINGIZE(__GLIBCXX__); };
#else
#  define MOSAIQ_EXPORT_GLIBCXX_VERSION \
    DLL_EXPORT char const* mosaiq_glibcxx_version() { return ""; };
#endif

#ifdef _LIBCPP_VERSION
#  define MOSAIQ_EXPORT_LIBCPP_VERSION \
    DLL_EXPORT char const* mosaiq_libcpp_version() \
    { \
      return MOSAIQ_SDK_STRINGIZE(_LIBCPP_VERSION); \
    };
#else
#  define MOSAIQ_EXPORT_LIBCPP_VERSION \
    DLL_EXPORT char const* mosaiq_libcpp_version() { return ""; };
#endif

#ifdef __GLIBC__
#  define MOSAIQ_EXPORT_GLIBC_VERSION \
    DLL_EXPORT char const* mosaiq_glibc_version() \
    { \
      return MOSAIQ_SDK_STRINGIZE(__GLIBC__) "." MOSAIQ_SDK_STRINGIZE(__GLIBC_MINOR__); \
    };
#elif defined(__GNU_LIBRARY__)
#  define MOSAIQ_EXPORT_GLIBC_VERSION \
    DLL_EXPORT char const* mosaiq_glibc_version() \
    { \
      return MOSAIQ_SDK_STRINGIZE(__GNU_LIBRARY__) "." MOSAIQ_SDK_STRINGIZE( \
        __GNU_LIBRARY_MINOR__); \
    };
#else
#  define MOSAIQ_EXPORT_GLIBC_VERSION \
    DLL_EXPORT char const* mosaiq_glibc_version() { return ""; };
#endif

#define GENERATE_VERSION_INFORMATION() \
  MOSAIQ_EXPORT_GLIBCPP_VERSION \
  MOSAIQ_EXPORT_GLIBCXX_VERSION \
  MOSAIQ_EXPORT_LIBCPP_VERSION \
  MOSAIQ_EXPORT_GLIBC_VERSION

#endif // MOSAIQ_SDK_VERSIONINFO_H
