#ifndef MOSAIQ_SDK_INTERCOM_READER_H
#define MOSAIQ_SDK_INTERCOM_READER_H

#include "declarations.h"
#include "error.h"

typedef struct MosaiqIntercomReader
{
  /// The amount of bytes available to read
  unsigned long amountReadable;

  /// The port this call was made with.
  struct MosaiqIntercomSubscription const* subscription;

  /// A function you can use to read with a self allocated buffer.
  MosaiqIntercomReadResult (*read)(
    struct MosaiqIntercomSubscription const* subscription, void* value, unsigned long amount);

  /// Use this variation if you only need a part of the whole thing.
  MosaiqIntercomReadResult (*read_partial)(
    struct MosaiqIntercomSubscription const* subscription,
    void* value,
    unsigned long amount,
    unsigned long offset);

} MosaiqIntercomReader;

#endif // MOSAIQ_SDK_INTERCOM_READER_H
