#ifndef MOSAIQ_SDK_INTERCOM_PUBLICATION_H
#define MOSAIQ_SDK_INTERCOM_PUBLICATION_H

#include "declarations.h"
#include "error.h"

/**
 * A publication can be used to perform write operations on a topic. Only one app can publish a
 * topic described by name at a time.
 */
typedef struct MosaiqIntercomPublication
{
  /**
   * Writes a new value to the published topic. Can only be used for fundamental types.
   * @param self Pass the publication itself
   * @param value A pointer to variable holding the value you want to write.
   */
  MosaiqIntercomWriteResult (*write)(MosaiqIntercomPublication* self, void const* value);

  /**
   * Writes a new value to a published topic that is of variable length (strings, ...)
   * @param self Pass the publication itself
   * @param value A pointer to variable holding the value you want to write.
   * @param size The amount of bytes to write.
   */
  MosaiqIntercomWriteResult (*write_sized)(
    MosaiqIntercomPublication* self, void const* value, unsigned long size);

  /// Reserved for use by the runtime.
  MosaiqIntercomTopic* m_topic;
} MosaiqIntercomPublication;

#endif // MOSAIQ_SDK_INTERCOM_PUBLICATION_H
