#ifndef MOSAIQ_SDK_INTERCOM_SUBSCRIPTION_H
#define MOSAIQ_SDK_INTERCOM_SUBSCRIPTION_H

#include "declarations.h"
#include "reader.h"

/**
 * A subscription can be used to perform read operations on a topic.
 */
typedef struct MosaiqIntercomSubscription
{
  /**
   * Reads a value from the subscribed topic. Can only be used for fundamental types.
   * @param self Pass the subscription itself.
   * @param value A pointer to a variable that is then filled with the read value.
   */
  MosaiqIntercomReadResult (*read)(MosaiqIntercomSubscription const* self, void* value);

  /**
   * Reads a value from the subscribed topic.
   * @param self Pass the subscription itself.
   * @param userContext You can use this parameter to access your local call context in the reader
   * function. This could be a class instance or some other object.
   * @param reader This reader function is called from which you can read the data into your own
   * buffer. The userContext is passed back into this function.
   */
  MosaiqIntercomReadResult (*read_sized)(
    MosaiqIntercomSubscription const* self,
    void* userContext,
    void (*reader)(void* userContext, MosaiqIntercomReader const* reader));

  /**
   * Reads a value from the subscribed topic that is of known fixed size.
   * Only use this function for fixed size structs and fixed size arrays.
   * @param self Pass the subscription itself.
   * @param value The value to write to.
   * @param amount The size of the value in bytes.
   * @param offset An offset in bytes where to start reading from.
   */
  MosaiqIntercomReadResult (*read_fixed)(
    MosaiqIntercomSubscription const* self,
    void* value,
    unsigned long amount,
    unsigned long offset);

  /// Reserved for use by the runtime.
  MosaiqIntercomTopic* m_topic;
} MosaiqIntercomSubscription;

#endif // MOSAIQ_SDK_INTERCOM_SUBSCRIPTION_H
