#ifndef MOSAIQ_SDK_INTERCOM_H
#define MOSAIQ_SDK_INTERCOM_H

#include "declarations.h"
#include "publication.h"
#include "reader.h"
#include "subscription.h"

#include "error.h"
#include "type.h"

#ifdef __cplusplus
#  include <cstdint>
#else
#  include <stdint.h>
#endif

/**
 * Use is only permitted during the on_initialization phase.
 */
struct MosaiqIntercomAppBroker
{
  // This variable is filled with a version
  int64_t version;

  /// Reserved for use by the runtime.
  MosaiqIntercomAppBrokerImplementation* m_impl;

  /**
   * Publish a topic for other apps to subscribe to.
   * Will fail if another app already published this topic.
   *
   * @param self Pass the broker itself here.
   * @param port (output) A newly created publication you can use for writes.
   * @param topic The topic name to publish for others to subscribe to.
   * @param type A type for the published topic. Subscriptions have to match this type.
   * @param defaultValue (optional) A default value to initialize the data with. nulled otherwise.
   * @param defaultValueSize (optional) The size of the default value. Only required if the type has
   *variable size.
   **/
  MosaiqIntercomPublishResult (*publish)(
    MosaiqIntercomAppBroker* self,
    MosaiqIntercomPublication** port,
    char const* topic,
    MosaiqIntercomType type,
    void const* defaultValue,
    unsigned long defaultValueSize);

  /**
   * Subscribe to a topic published by another app.
   *
   * @param self Pass the broker itself here.
   * @param port (output) A newly created subscription you can use for writes.
   * @param topic The topic name to subscribe to.
   * @param type A type for the published topic including its size.
   **/
  MosaiqIntercomSubscribeResult (*subscribe)(
    MosaiqIntercomAppBroker* self,
    MosaiqIntercomSubscription** port,
    char const* topic,
    MosaiqIntercomType type);
};

#endif // MOSAIQ_SDK_INTERCOM_H
