use std::ffi::OsString;

fn help() {
    println!("{}", format!("\
morseclock-hw - blinky time - version {}

usage: morseclock-hw [-h] -p PAUSE_TIME -b BLINK_TIME -l LONG_DUTY_CYCLE -s SHORT_DUTY_CYCLE -P PATH_TO_LED

", env!("CARGO_PKG_VERSION")));
}

#[derive(Debug)]
struct Args {
    led: OsString,
    pause_time: u32,
    blink_time: u32,
    long_duty: f32,
    short_duty: f32,
}

fn args() -> anyhow::Result<Args> {
    let mut args = pico_args::Arguments::from_env();

    if args.contains(["-h", "--help"]) {
        help();
        std::process::exit(0);
    }

    Ok(Args {
        led: OsString::new(),
        pause_time: 0,
        blink_time: 0,
        long_duty: 0.5,
        short_duty: 0.5,
    })
}

fn app() -> anyhow::Result<()> {
    let args = args()?;

    Ok(())
}

fn main() {
    if let Err(e) = app() {
        eprintln!("Error: {}", e);
        std::process::exit(1);
    }
}