(defn caar (x)
     (car (car x)))

(defn null (x)
  (eq x '()))

(defn and (x y)
  (cond (x (cond (y true) (true false)))
        (true false)))

(defn not (x)
  (cond (x false)
        (true true)))

(defn append (x y)
  (cond ((null x) y)
        (true (cons (car x) (append (cdr x) y)))))

(defn list (x y)
  (cons x (cons y '())))

(defn pair (x y)
  (cond ((and (null x) (null y)) '())
        ((and (not (atom x)) (not (atom y)))
         (cons (list (car x) (car y))
               (pair (cdr x) (cdr y))))))

(defn assoc (x y)
  (cond ((eq (caar y) x) (cadar y))
        (true (assoc x (cdr y)))))

(defn eval (e a)
  (cond
    ((atom e) (assoc e a))
    ((atom (car e))
     (cond
       ((eq (car e) 'quote) (cadr e))
       ((eq (car e) 'atom)  (atom   (eval (cadr e) a)))
       ((eq (car e) 'eq)    (eq     (eval (cadr e) a)
                                    (eval (caddr e) a)))
       ((eq (car e) 'car)   (car    (eval (cadr e) a)))
       ((eq (car e) 'cdr)   (cdr    (eval (cadr e) a)))
       ((eq (car e) 'cons)  (cons   (eval (cadr e) a)
                                    (eval (caddr e) a)))
       ((eq (car e) 'cond)  (evcon (cdr e) a))
       (true (eval (cons (assoc (car e) a)
                        (cdr e))
                  a))))
    ((eq (caar e) 'label)
     (eval (cons (caddar e) (cdr e))
            (cons (list (cadar e) (car e)) a)))
    ((eq (caar e) 'lambda)
     (eval (caddar e)
            (append (pair (cadar e) (evlis (cdr e) a))
                     a)))))

(defn evcon (c a)
  (cond ((eval (caar c) a)
         (eval (cadar c) a))
        (true (evcon (cdr c) a))))

(defn evlis (m a)
  (cond ((null m) '())
        (true (cons (eval  (car m) a)
                  (evlis (cdr m) a)))))
