const CopyPlugin = require("copy-webpack-plugin");
const path = require('path');

module.exports = {
  entry: "./bootstrap.js",
  output: {
    path: path.resolve(__dirname, "dist"),
    filename: "bootstrap.js",
  },
  module: {
    rules: [
      {
        test: /\.wasm$/,
        type: 'webassembly/sync',
      }
    ]
  },
  experiments: {
    syncWebAssembly: true
  },
  mode: "development",
  plugins: [
    new CopyPlugin({
      patterns: [
        "index.html",
        "favicon.ico",
        { from: "texture", to: "texture" },
      ]
    }),
  ],
};
