# Monster

[![Build Status](https://img.shields.io/github/workflow/status/cksystemsgroup/monster/Test)](https://github.com/cksystemsgroup/monster/actions)
[![Crate](https://img.shields.io/crates/v/monster-rs.svg)](https://crates.io/crates/monster-rs)
[![API](https://docs.rs/monster-rs/badge.svg)](https://docs.rs/monster-rs)
![Experimental Status](https://img.shields.io/badge/status-experimental-yellow.svg)
![Rust Version](https://img.shields.io/badge/Rust-v1.52.0-yellow)
![Platform](https://img.shields.io/badge/platform-linux%20%7C%20macos%20%7C%20windows-brightgreen)
[![Lines of Code](https://img.shields.io/tokei/lines/github/cksystemsgroup/monster)](https://github.com/cksystemsgroup/monster)
[![License](https://img.shields.io/crates/l/monster-rs)](https://github.com/cksystemsgroup/monster/blob/master/LICENSE)

Monster is an incomplete symbolic execution engine for 64-bit RISC-U binaries generated by [Selfie](https://github.com/cksystemsteaching/selfie). 
It can find bugs like division by zero of an unknown binary. 
It's incompleteness is used as an advantage, by using an shortest path exploration strategy based on the binary code structure, to prune the state search space optimistically. 
In the backend an incomplete SMT solver is implemented, which further boosts performance.
Popular SMT solvers like Boolector and Z3 are also supported as an optional build option.

### Usage

#### Binary

Once Rust is installed (see step 1 in "Toolchain Setup"), you can easily install the latest version of Monster with:
```
$ cargo install monster-rs --locked
$ monster --help
```

#### Library
Usage

Add this to your Cargo.toml:
```
[dependencies]
monster-rs = "0"
```

### Toolchain Setup
Monster can be build and tested on all major platforms.
Just make sure you build for one of these targets:
 - x86_64-unknown-linux-gnu
 - x86_64-apple-darwin
 - x86_64-pc-windows-msvc

1. Bootstrap Rust v1.52.0 from [https://rustup.rs](https://rustup.rs) and make sure:
 - you install it with one of the supported host triples and 
 - add it to your path
2. Install Rustfmt (formatter) and Clippy (linter)
```
$ rustup component add rustfmt
$ rustup component add clippy
```
4. Install tool for documentation generation
```
$ cargo install mdbook --locked
$ cargo install mdbook-linkcheck --locked
$ cargo install mdbook-graphviz --locked
```
5. Install tools to build Selfie with our favorite package manager

MacOs:
```
$ brew install make gcc git
```
Linux:
```
$ apt install make gcc git
```
Windows:
```
$ choco install make -y
$ choco install mingw -y
$ choco install git -y
```
### Build and Test from Source
Tests can be executed on all platforms, alltough one
feature is not supported on Windows: `boolector`

1. Test your toolchain setup by compiling monster:
```
$ cargo build --locked
```
2. Execute tests:
```
$ cargo test --locked
```

## License

Copyright (c) 2020, [the Selfie authors](https://github.com/cksystemsteaching/selfie). All rights reserved.

Licensed under the [MIT](LICENSE) license.
