use crate::proto::{monsta_client::MonstaClient, *};

use tonic::transport::Channel;

pub struct Collection {
    desc: CollectionDesc,
    client: MonstaClient<Channel>,
}

impl Collection {
    pub fn new(desc: CollectionDesc, client: MonstaClient<Channel>) -> Self {
        Self { desc, client }
    }

    pub fn desc(&self) -> &CollectionDesc {
        &self.desc
    }
}
