use std::io::{self, Write};

use anyhow::Result;
use clap::Parser;
use monsta::client::{Collection, CollectionSpec, Database, DatabaseSpec, Universe};

#[derive(Parser)]
pub struct Command {
    #[clap(long, default_value = "localhost:21716")]
    addr: String,
}

impl Command {
    pub async fn run(self) -> Result<()> {
        let uv = Universe::connect(self.addr).await?;
        let mut db: Option<Database> = None;
        let mut co: Option<Collection> = None;
        let stdin = io::stdin();
        let mut stdout = io::stdout();
        loop {
            print!("> ");
            stdout.flush()?;
            let mut line = String::new();
            stdin.read_line(&mut line)?;
            let mut token = line.split_whitespace();
            if let Some(op) = token.next() {
                match op {
                    "create" => {
                        if let Some(resource) = token.next() {
                            match resource {
                                "database" => {
                                    if let Some(name) = token.next() {
                                        let spec = DatabaseSpec {
                                            name: name.to_owned(),
                                        };
                                        db = Some(uv.create_database(spec).await?);
                                        println!("{:?}", db.as_ref().unwrap().desc());
                                    }
                                }
                                "collection" => {
                                    if let Some(name) = token.next() {
                                        let spec = CollectionSpec {
                                            name: name.to_owned(),
                                        };
                                        co = Some(
                                            db.as_ref().unwrap().create_collection(spec).await?,
                                        );
                                        println!("{:?}", co.as_ref().unwrap().desc());
                                    }
                                }
                                _ => println!("invalid resource '{}'", resource),
                            }
                        }
                    }
                    _ => println!("invalid operation '{}'", op),
                }
            }
        }
    }
}
