use std::sync::Arc;

use monsta_proto::*;
use tokio::sync::Mutex;

#[derive(Clone)]
pub struct Collection {
    inner: Arc<Mutex<Inner>>,
}

struct Inner {
    desc: CollectionDesc,
}

impl Collection {
    pub fn new(database_id: u64, collection_id: u64, spec: CollectionSpec) -> Self {
        let desc = CollectionDesc {
            id: collection_id,
            name: spec.name,
            database_id,
        };
        let inner = Inner { desc };
        Self {
            inner: Arc::new(Mutex::new(inner)),
        }
    }

    pub async fn desc(&self) -> CollectionDesc {
        let inner = self.inner.lock().await;
        inner.desc.clone()
    }
}
