pub struct DatabaseSpec(monsta_proto::DatabaseSpec);

impl Into<monsta_proto::DatabaseSpec> for DatabaseSpec {
    fn into(self) -> monsta_proto::DatabaseSpec {
        self.0
    }
}

impl From<&str> for DatabaseSpec {
    fn from(name: &str) -> Self {
        Self(monsta_proto::DatabaseSpec {
            name: name.to_owned(),
        })
    }
}

impl From<String> for DatabaseSpec {
    fn from(name: String) -> Self {
        Self(monsta_proto::DatabaseSpec { name })
    }
}

pub struct CollectionSpec(monsta_proto::CollectionSpec);

impl Into<monsta_proto::CollectionSpec> for CollectionSpec {
    fn into(self) -> monsta_proto::CollectionSpec {
        self.0
    }
}

impl From<&str> for CollectionSpec {
    fn from(name: &str) -> Self {
        Self(monsta_proto::CollectionSpec {
            name: name.to_owned(),
            ..Default::default()
        })
    }
}

impl From<String> for CollectionSpec {
    fn from(name: String) -> Self {
        Self(monsta_proto::CollectionSpec {
            name,
            ..Default::default()
        })
    }
}
