use monsta_proto::*;

use crate::{client::Client, Error, Result};

pub struct Collection {
    client: Client,
    database_id: u64,
    collection_id: u64,
}

impl Collection {
    pub fn new(client: Client, database_id: u64, collection_id: u64) -> Self {
        Self {
            client,
            database_id,
            collection_id,
        }
    }

    pub async fn desc(&self) -> Result<CollectionDesc> {
        let req = CollectionRequest {
            database_id: self.database_id,
            describe_collection: Some(DescribeCollectionRequest {
                id: self.collection_id,
                ..Default::default()
            }),
            ..Default::default()
        };
        let res = self.client.collection_call(req).await?;
        let desc = res
            .describe_collection
            .and_then(|x| x.desc)
            .ok_or_else(|| Error::InvalidResponse)?;
        Ok(desc)
    }
}
