use monsta_proto::{monsta_client::MonstaClient, *};
use tonic::transport::Channel;

use crate::{Error, Result};

#[derive(Clone)]
pub struct Client {
    client: MonstaClient<Channel>,
}

impl Client {
    pub async fn connect(url: impl Into<String>) -> Result<Self> {
        let client = MonstaClient::connect(url.into())
            .await
            .map_err(Error::unknown)?;
        Ok(Self { client })
    }

    pub async fn database_call(&self, req: DatabaseRequest) -> Result<DatabaseResponse> {
        let req = Request {
            database: Some(req),
            ..Default::default()
        };
        let mut client = self.client.clone();
        let res = client.call(req).await?;
        res.into_inner()
            .database
            .ok_or_else(|| Error::InvalidResponse)
    }

    pub async fn collection_call(&self, req: CollectionRequest) -> Result<CollectionResponse> {
        let req = Request {
            collection: Some(req),
            ..Default::default()
        };
        let mut client = self.client.clone();
        let res = client.call(req).await?;
        res.into_inner()
            .collection
            .ok_or_else(|| Error::InvalidResponse)
    }
}
