use anyhow::Result;
use monsta_client::Universe;

#[tokio::main]
async fn main() -> Result<()> {
    let url = "http://localhost:21716".to_owned();
    let uv = Universe::connect(url).await?;
    let db = uv.create_database("db").await?;
    println!("{:?}", db.desc().await?);
    let co = db.create_collection("co").await?;
    println!("{:?}", co.desc().await?);
    Ok(())
}
