use crate::{
    moniker::Moniker,
    random::{Random, SeedSource},
};

/// # Examples
/// ```
/// # use moniker_rs::Moniker;
/// # use moniker_rs::Animal;
/// let moniker = Animal::get_random();
///
/// println!("{}", moniker);
/// ```
pub struct Animal;

impl Animal {
    pub fn get_names() -> &'static [&'static str] {
        NAMES
    }

    pub fn get_descriptors() -> &'static [&'static str] {
        DESCRIPTORS
    }
}

impl Moniker for Animal {
    fn get_random() -> String {
        let name_index = Random::random_max(NAMES.len() as u64, SeedSource::Time);
        let descriptor_index = Random::random_max(DESCRIPTORS.len() as u64, SeedSource::Time);

        let name = NAMES[name_index as usize];
        let descriptor = DESCRIPTORS[descriptor_index as usize];

        format!("{}-{}", descriptor, name)
    }
}

const NAMES: &[&str] = &[
    "aardvark",
    "aardwolf",
    "abalone",
    "albatross",
    "alligator",
    "alpaca",
    "anaconda",
    "angelfish",
    "ant",
    "anteater",
    "antelope",
    "arachnid",
    "armadillo",
    "badger",
    "bat",
    "bear",
    "bee",
    "beetle",
    "billygoat",
    "bird",
    "bison",
    "blackbird",
    "bobcat",
    "boxer",
    "bronco",
    "buffalo",
    "buffoon",
    "bumblebee",
    "bunny",
    "butterfly",
    "camel",
    "cardinal",
    "cat",
    "catfish",
    "cheetah",
    "chicken",
    "chimp",
    "chinchilla",
    "chipmunk",
    "clam",
    "clownfish",
    "condor",
    "coral",
    "cow",
    "crab",
    "cricket",
    "crocodile",
    "dachshund",
    "deer",
    "dingo",
    "dog",
    "dolphin",
    "donkey",
    "dragon",
    "dragonfly",
    "duck",
    "eagle",
    "echidna",
    "eel",
    "elephant",
    "elk",
    "emu",
    "ferret",
    "fish",
    "flee",
    "fly",
    "fox",
    "frog",
    "garfish",
    "gecko",
    "gerbil",
    "gibbon",
    "giraffe",
    "gnat",
    "goat",
    "goose",
    "gopher",
    "gorilla",
    "grasshopper",
    "greyhound",
    "grizzly",
    "guppy",
    "hamster",
    "hare",
    "hedgehog",
    "heron",
    "hog",
    "horse",
    "hound",
    "hummingbird",
    "hydra",
    "hyena",
    "ibex",
    "ibis",
    "iguana",
    "indri",
    "jackal",
    "jaguar",
    "jellyfish",
    "joey",
    "kangaroo",
    "kitten",
    "kiwi",
    "koala",
    "kudu",
    "labradoodle",
    "ladybird",
    "ladybug",
    "lamb",
    "lambkin",
    "lemur",
    "leopard",
    "liger",
    "lightningbug",
    "lion",
    "lionfish",
    "lizard",
    "llama",
    "lobster",
    "lynx",
    "macaw",
    "magpie",
    "maltese",
    "manatee",
    "mandrill",
    "manta",
    "markhor",
    "marmot",
    "marsupial",
    "mastiff",
    "meerkat",
    "mink",
    "mite",
    "mole",
    "molly",
    "mongoose",
    "monkey",
    "moose",
    "moth",
    "mouse",
    "mule",
    "narwhal",
    "newt",
    "nightingale",
    "numbat",
    "ocelot",
    "octopus",
    "olm",
    "opossum",
    "orangutan",
    "ostrich",
    "otter",
    "owl",
    "oyster",
    "panda",
    "panther",
    "parrot",
    "peacock",
    "peahen",
    "penguin",
    "pig",
    "pika",
    "pike",
    "platypus",
    "poodle",
    "porcupine",
    "possum",
    "prawn",
    "pronghorn",
    "puffin",
    "pug",
    "puma",
    "quail",
    "quetzal",
    "quokka",
    "quoll",
    "rabbit",
    "raccoon",
    "ragdoll",
    "rat",
    "rattlesnake",
    "robin",
    "rodent",
    "rottweiler",
    "sabertooth",
    "salamander",
    "saola",
    "sasquatch",
    "scorpion",
    "seagull",
    "seahorse",
    "seal",
    "seastar",
    "serval",
    "shark",
    "sheep",
    "shrimp",
    "skunk",
    "sloth",
    "snail",
    "snake",
    "spaniel",
    "sparrow",
    "sponge",
    "squid",
    "squirrel",
    "starfish",
    "stingray",
    "stoat",
    "swan",
    "tapir",
    "tarsier",
    "termite",
    "terrier",
    "tiger",
    "toad",
    "tortoise",
    "toucan",
    "tuatara",
    "turkey",
    "turtle",
    "uakari",
    "umbrellabird",
    "unicorn",
    "vulture",
    "wallaby",
    "walrus",
    "warthog",
    "wasp",
    "waterbuffalo",
    "whale",
    "whippet",
    "wildebeest",
    "wolf",
    "wolverine",
    "wombat",
    "woodpecker",
    "worm",
    "yak",
    "zebra",
    "zebu",
    "zorse",
];

const DESCRIPTORS: &[&str] = &[
    "affable",
    "aged",
    "agile",
    "alert",
    "alliterating",
    "altered",
    "alternating",
    "amber",
    "angry",
    "anxious",
    "ardent",
    "aspiring",
    "austere",
    "auxiliary",
    "awesome",
    "bailing",
    "bald",
    "banking",
    "belligerent",
    "billowing",
    "binging",
    "boiling",
    "boisterous",
    "bold",
    "braided",
    "brawny",
    "brazen",
    "broken",
    "brown",
    "bulging",
    "bumptious",
    "bunking",
    "busted",
    "calico",
    "calling",
    "callous",
    "cantankerous",
    "cautious",
    "cloying",
    "clunky",
    "coiled",
    "coiling",
    "cold",
    "contrasting",
    "coy",
    "crabby",
    "cranky",
    "crazy",
    "crusty",
    "dandy",
    "dangling",
    "dapper",
    "deadly",
    "dealing",
    "dining",
    "dinky",
    "doltish",
    "donating",
    "dozing",
    "dull",
    "dunking",
    "dusty",
    "eager",
    "early",
    "eating",
    "edgy",
    "eerie",
    "elder",
    "elegant",
    "elevated",
    "eloping",
    "enervated",
    "eponymous",
    "errant",
    "erstwhile",
    "esteemed",
    "estranged",
    "exacerbated",
    "exasperated",
    "excited",
    "exciting",
    "exegetical",
    "exhaling",
    "exiled",
    "existing",
    "eyewitness",
    "factual",
    "fair",
    "fallacious",
    "falling",
    "famous",
    "fancy",
    "fantastic",
    "fashionable",
    "filled",
    "flabby",
    "flailing",
    "flippant",
    "foiled",
    "foolhardy",
    "foolish",
    "foppish",
    "full",
    "fun",
    "funky",
    "funny",
    "fuzzy",
    "gangly",
    "garish",
    "gauche",
    "gaudy",
    "geared",
    "giddy",
    "giggly",
    "gilded",
    "gone",
    "good",
    "goodly",
    "guiding",
    "halting",
    "handy",
    "happy",
    "hardy",
    "harping",
    "hasty",
    "hazy",
    "hipster",
    "hissing",
    "historical",
    "honest",
    "honking",
    "honorary",
    "hoping",
    "hopping",
    "iced",
    "icy",
    "ideal",
    "idle",
    "idolized",
    "ignoble",
    "ignorant",
    "ill",
    "illmannered",
    "illocutionary",
    "imprecise",
    "impressive",
    "incendiary",
    "inclined",
    "independent",
    "inky",
    "innocent",
    "insipid",
    "intended",
    "intent",
    "intentional",
    "interested",
    "interesting",
    "invincible",
    "invisible",
    "invited",
    "iron",
    "ironic",
    "irreverent",
    "jaundiced",
    "jaunty",
    "jazzed",
    "jazzy",
    "jittery",
    "joking",
    "jolly",
    "joyous",
    "juiced",
    "jumpy",
    "khaki",
    "killer",
    "killjoy",
    "kilted",
    "kind",
    "kindled",
    "kindly",
    "kindred",
    "kissable",
    "kissed",
    "kissing",
    "kneeling",
    "knobby",
    "knotted",
    "lame",
    "lanky",
    "laughing",
    "lazy",
    "left",
    "limping",
    "linting",
    "listening",
    "listless",
    "littering",
    "loitering",
    "lolling",
    "looming",
    "looping",
    "loopy",
    "loping",
    "lopsided",
    "lovely",
    "lucky",
    "lumbering",
    "luminous",
    "lumpy",
    "lunging",
    "manageable",
    "mangy",
    "masked",
    "maudlin",
    "mean",
    "measly",
    "melting",
    "messy",
    "mewing",
    "misty",
    "modest",
    "moldy",
    "mollified",
    "morbid",
    "mortal",
    "mothy",
    "mottled",
    "mouthy",
    "muddled",
    "musty",
    "named",
    "nasal",
    "needled",
    "newbie",
    "nihilist",
    "nobby",
    "nomadic",
    "nonexistent",
    "nonplussed",
    "nordic",
    "nosy",
    "nuanced",
    "odd",
    "oily",
    "old",
    "oldfashioned",
    "olfactory",
    "open",
    "operatic",
    "opining",
    "opinionated",
    "opulent",
    "orange",
    "orbiting",
    "ordered",
    "orderly",
    "original",
    "ornery",
    "peddling",
    "peeking",
    "pilfering",
    "pining",
    "pioneering",
    "piquant",
    "plinking",
    "plucking",
    "plundering",
    "pondering",
    "ponderous",
    "pouring",
    "precise",
    "prodding",
    "pruning",
    "pugnacious",
    "punk",
    "quaffing",
    "quarreling",
    "quarrelsome",
    "queenly",
    "quelling",
    "quiet",
    "quieting",
    "quoting",
    "rafting",
    "ranting",
    "reeling",
    "right",
    "righteous",
    "ringed",
    "riotous",
    "roiling",
    "rolling",
    "romping",
    "rousing",
    "rude",
    "running",
    "sad",
    "sanguine",
    "sappy",
    "sartorial",
    "saucy",
    "silly",
    "singed",
    "singing",
    "smelly",
    "snug",
    "soft",
    "solemn",
    "solid",
    "solitary",
    "steely",
    "stultified",
    "sullen",
    "sweet",
    "tailored",
    "tan",
    "telling",
    "terrific",
    "terrifying",
    "tinseled",
    "toned",
    "torpid",
    "torrid",
    "trendsetting",
    "trendy",
    "triangular",
    "truculent",
    "tufted",
    "turbulent",
    "ugly",
    "ulterior",
    "undercooked",
    "understood",
    "ungaged",
    "unhinged",
    "unrealistic",
    "unrealized",
    "unsung",
    "veering",
    "vehement",
    "vested",
    "vetoed",
    "viable",
    "vigilant",
    "virtuous",
    "virulent",
    "vocal",
    "vociferous",
    "volted",
    "voting",
    "wandering",
    "wanton",
    "warped",
    "washed",
    "washing",
    "waxen",
    "wayfaring",
    "whimsical",
    "whopping",
    "wiggly",
    "willing",
    "winning",
    "winsome",
    "wintering",
    "wise",
    "wishful",
    "wishing",
    "wistful",
    "wizened",
    "wobbling",
    "wobbly",
    "womping",
    "wonderful",
    "wondering",
    "worn",
    "wrapping",
    "wrinkled",
    "xrayed",
    "yellow",
    "yodeling",
    "youngling",
    "your",
    "youthful",
    "yucky",
    "yummy",
    "zealous",
    "zeroed",
    "zinc",
    "zooming",
];
