use proc_macro::*;
use quote::quote;

#[proc_macro_attribute]
pub fn modifier(_args: TokenStream, input: TokenStream) -> TokenStream {
    let args = _args.to_string();
    let mut item: syn::Item = syn::parse(input).unwrap();
    let fn_item = match &mut item {
        syn::Item::Fn(fn_item) => fn_item,
        _ => panic!("expected fn")
    };
    match args.as_str() {
        "onlyOwner" => {
            fn_item.block.stmts.insert(0,syn::parse(quote!({let state = STATE.load(deps.storage)?; if info.sender != state.owner {return Err(ContractError::Unauthorized {});};}).into()).unwrap());
        }
        "active" => {
            fn_item.block.stmts.insert(0,syn::parse(quote!({println!("invoke modifier {}", "active");println!("checking contract expired");}).into()).unwrap());
        }
        _ => {

        }
    }

    use quote::ToTokens;
    item.into_token_stream().into()
}