extern crate modbus_iiot;

use modbus_iiot::tcp::master::TcpClient;
use modbus_iiot::tcp::masteraccess::MasterAccess;
use postgres::{Client, NoTls};

fn main() {
    let mut client = TcpClient::new("10.54.52.201:502");
    let result = client.connect();
    match result {
        Err(message) => println!("Ups, No Modbus world! {}", message),
        Ok(_) => {
            println!("Hello, Modbus world!");
            reading_input_registers(&mut client);

            client.disconnect();
        }
    }
}

fn reading_input_registers(client: &mut TcpClient) {
    let temperature_response = client.read_input_registers(00015, 1);
    println!("Response IR temperature indoor: {:?}", temperature_response);

    let x = temperature_response[0];

    println!("{}", x);

    let humidity_response = client.read_input_registers(00016, 1);
    println!("Response IR humidity indoor: {:?}", humidity_response);

    let illumination_indoor_response = client.read_input_registers(00017, 1);
    println!(
        "Response IR illumination indoor: {:?}",
        illumination_indoor_response
    );

    let connection_response = client.read_input_registers(00019, 1);
    println!("Response IR connection: {:?}", connection_response);

    let mut client =
        Client::connect("postgresql://stepanov:postgres@localhost/postgres", NoTls).unwrap();

    let temperature: i32 = temperature_response[0] as i32;
    let humidity: i32 = humidity_response[0] as i32;
    let illumination_indoor: i32 = illumination_indoor_response[0] as i32;
    let connection: i32 = connection_response[0] as i32;
    client.execute(
        "INSERT INTO modbus_test (temperature, humidity, illumination_indoor, connection) VALUES ($1, $2, $3, $4)",
        &[&temperature, &humidity, &illumination_indoor, &connection],
    ).unwrap();

    for row in client.query("SELECT temperature, humidity, illumination_indoor, connection FROM modbus_test ORDER BY mark DESC limit 1", &[]).unwrap() {
        let temperature: i32 = row.get(0);
        let humidity: i32 = row.get(1);
        let illumination_indoor: i32 = row.get(2);
        let connection: i32 = row.get(3);
        println!(
            "latest values of modbus_test: temperature: {}°C humidity: {}% illumination_indoor: {}lux connection: {}",
            temperature, humidity, illumination_indoor, connection);
    }
}
