# mmtkvdb

`mmtkvdb` is a crate for Rust which provides a memory-mapped key-value
database. It uses LMDB and links with an existing `liblmdb` on the system.

## API Documentation

For documentation on how to use this crate, refer to the example in
`src/lib.rs`.

## License

See contained `LICENSE` file (MIT License).

## Changelog

* 2022-04-30: Version 0.0.5
    * Method `EnvRo::txn` moved to `Env` trait and renamed to `Env::txn_ro`.
    * Method `EnvRw::txn` renamed to `EnvRw::txn_rw`.
    * Improved documentation of `EnvRo` and `EnvRw` (doc comment explains how
      to create them now, i.e. how to start a transaction)
* 2022-04-22: Version 0.0.4
    * No longer use `PhantomData` to store unit-like structs which indicate
      constraints on key uniqueness in `DbOptions` and `Db` (`KeysUnique` and
      `KeysDuplicate` are `Copy` now and contained directly)
    * Minor fixes in documentation
        * Changed argument name for passing `DbOptions` to `Env::open_dbs`
        * Added link to `Sized` in doc comment on private trait `IsType`
* 2022-04-16: Version 0.0.3
    * Avoid transmute on references: To avoid issues with (possible) future
      changes in Rust, the `storable` module doesn't use `transmute` on
      references anymore. Instead, `std::slice::from_raw_parts`,
      `std::str::from_utf8_unchecked`, and `str::as_bytes()` are used.
* 2022-04-11: Version 0.0.2
    * Moved `Storable`, `StorableConstBytesLen`, and `StorableWithOwned` traits
      to new (public) `storable` module (but `Storable` gets re-exported by
      crate-level module)
    * Added method to clear stale readers
    * Improved documentation on (un)safety
    * Avoid unnecessary re-alignment in some cases of `u8` and `i8`
    * Make type `bool` storable (i.e. implement `Storable` for `bool`)
    * Added documentation comments for private items
    * Code cleanup (moved private `IsType` trait to `helpers` module)
* 2022-04-10: Version 0.0.1
    * First release
