/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *  Copyright  (C)  2019-2021  Christian Krause                              *
 *                                                                           *
 *  Christian Krause  <christian.krause@idiv.de>                             *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                           *
 *  This file is part of mmdu.                                               *
 *                                                                           *
 *  mmdu is free software: you can redistribute it and/or modify             *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation, either version 3 of the license, or any    *
 *  later version.                                                           *
 *                                                                           *
 *  mmdu is distributed in the hope that it will be useful, but              *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU         *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  You should have received a copy of the GNU General Public License along  *
 *  with mmdu. If not, see <http://www.gnu.org/licenses/>.                   *
 *                                                                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

use clap::ArgMatches;

pub struct Config {
    pub debug: bool,
    pub max_depth: Option<usize>,
    pub nodes: Option<String>,
    pub local_work_dir: Option<String>,
    pub global_work_dir: Option<String>,
}

impl Config {
    pub fn from_args(args: &ArgMatches) -> Self {
        let max_depth = args
            .value_of("max-depth")
            .map(|x| x.parse::<usize>().unwrap())
            .filter(|depth| *depth > 0);

        let nodes = args.value_of("nodes").map(String::from);

        let local_work_dir = args.value_of("local-work-dir").map(String::from);

        let global_work_dir =
            args.value_of("global-work-dir").map(String::from);

        Self {
            debug: args.is_present("debug"),
            max_depth,
            nodes,
            local_work_dir,
            global_work_dir,
        }
    }
}
