// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait ModemVoice {
    fn list_calls(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn delete_call(&self, path: dbus::Path) -> Result<(), dbus::Error>;
    fn create_call(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error>;
    fn calls(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
}

#[derive(Debug)]
pub struct ModemVoiceCallAdded {
    pub path: dbus::Path<'static>,
}

impl arg::AppendAll for ModemVoiceCallAdded {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.path, i);
    }
}

impl arg::ReadAll for ModemVoiceCallAdded {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemVoiceCallAdded {
            path: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemVoiceCallAdded {
    const NAME: &'static str = "CallAdded";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem.Voice";
}

#[derive(Debug)]
pub struct ModemVoiceCallDeleted {
    pub path: dbus::Path<'static>,
}

impl arg::AppendAll for ModemVoiceCallDeleted {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.path, i);
    }
}

impl arg::ReadAll for ModemVoiceCallDeleted {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemVoiceCallDeleted {
            path: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemVoiceCallDeleted {
    const NAME: &'static str = "CallDeleted";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem.Voice";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ModemVoice for blocking::Proxy<'a, C> {

    fn list_calls(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Voice", "ListCalls", ())
            .and_then(|r: (Vec<dbus::Path<'static>>, )| Ok(r.0, ))
    }

    fn delete_call(&self, path: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Voice", "DeleteCall", (path, ))
    }

    fn create_call(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Voice", "CreateCall", (properties, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn calls(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem.Voice", "Calls")
    }
}
