// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait Call {
    fn start(&self) -> Result<(), dbus::Error>;
    fn accept(&self) -> Result<(), dbus::Error>;
    fn hangup(&self) -> Result<(), dbus::Error>;
    fn send_dtmf(&self, dtmf: &str) -> Result<(), dbus::Error>;
    fn state(&self) -> Result<i32, dbus::Error>;
    fn state_reason(&self) -> Result<i32, dbus::Error>;
    fn direction(&self) -> Result<i32, dbus::Error>;
    fn number(&self) -> Result<String, dbus::Error>;
}

#[derive(Debug)]
pub struct CallDtmfReceived {
    pub dtmf: String,
}

impl arg::AppendAll for CallDtmfReceived {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.dtmf, i);
    }
}

impl arg::ReadAll for CallDtmfReceived {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(CallDtmfReceived {
            dtmf: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for CallDtmfReceived {
    const NAME: &'static str = "DtmfReceived";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Call";
}

#[derive(Debug)]
pub struct CallStateChanged {
    pub old: i32,
    pub new: i32,
    pub reason: u32,
}

impl arg::AppendAll for CallStateChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.old, i);
        arg::RefArg::append(&self.new, i);
        arg::RefArg::append(&self.reason, i);
    }
}

impl arg::ReadAll for CallStateChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(CallStateChanged {
            old: i.read()?,
            new: i.read()?,
            reason: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for CallStateChanged {
    const NAME: &'static str = "StateChanged";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Call";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> Call for blocking::Proxy<'a, C> {

    fn start(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Call", "Start", ())
    }

    fn accept(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Call", "Accept", ())
    }

    fn hangup(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Call", "Hangup", ())
    }

    fn send_dtmf(&self, dtmf: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Call", "SendDtmf", (dtmf, ))
    }

    fn state(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Call", "State")
    }

    fn state_reason(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Call", "StateReason")
    }

    fn direction(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Call", "Direction")
    }

    fn number(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Call", "Number")
    }
}
