// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait ModemTime {
    fn get_network_time(&self) -> Result<String, dbus::Error>;
    fn network_timezone(&self) -> Result<arg::PropMap, dbus::Error>;
}

#[derive(Debug)]
pub struct ModemTimeNetworkTimeChanged {
    pub time: String,
}

impl arg::AppendAll for ModemTimeNetworkTimeChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.time, i);
    }
}

impl arg::ReadAll for ModemTimeNetworkTimeChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemTimeNetworkTimeChanged {
            time: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemTimeNetworkTimeChanged {
    const NAME: &'static str = "NetworkTimeChanged";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem.Time";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ModemTime for blocking::Proxy<'a, C> {

    fn get_network_time(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Time", "GetNetworkTime", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn network_timezone(&self) -> Result<arg::PropMap, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem.Time", "NetworkTimezone")
    }
}
