// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait Modem {
    fn enable(&self, enable: bool) -> Result<(), dbus::Error>;
    fn list_bearers(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn create_bearer(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error>;
    fn delete_bearer(&self, bearer: dbus::Path) -> Result<(), dbus::Error>;
    fn reset(&self) -> Result<(), dbus::Error>;
    fn factory_reset(&self, code: &str) -> Result<(), dbus::Error>;
    fn set_power_state(&self, state: u32) -> Result<(), dbus::Error>;
    fn set_current_capabilities(&self, capabilities: u32) -> Result<(), dbus::Error>;
    fn set_current_modes(&self, modes: (u32, u32)) -> Result<(), dbus::Error>;
    fn set_current_bands(&self, bands: Vec<u32>) -> Result<(), dbus::Error>;
    fn set_primary_sim_slot(&self, sim_slot: u32) -> Result<(), dbus::Error>;
    fn command(&self, cmd: &str, timeout: u32) -> Result<String, dbus::Error>;
    fn sim(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn sim_slots(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn primary_sim_slot(&self) -> Result<u32, dbus::Error>;
    fn bearers(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn supported_capabilities(&self) -> Result<Vec<u32>, dbus::Error>;
    fn current_capabilities(&self) -> Result<u32, dbus::Error>;
    fn max_bearers(&self) -> Result<u32, dbus::Error>;
    fn max_active_bearers(&self) -> Result<u32, dbus::Error>;
    fn max_active_multiplexed_bearers(&self) -> Result<u32, dbus::Error>;
    fn manufacturer(&self) -> Result<String, dbus::Error>;
    fn model(&self) -> Result<String, dbus::Error>;
    fn revision(&self) -> Result<String, dbus::Error>;
    fn carrier_configuration(&self) -> Result<String, dbus::Error>;
    fn carrier_configuration_revision(&self) -> Result<String, dbus::Error>;
    fn hardware_revision(&self) -> Result<String, dbus::Error>;
    fn device_identifier(&self) -> Result<String, dbus::Error>;
    fn device(&self) -> Result<String, dbus::Error>;
    fn drivers(&self) -> Result<Vec<String>, dbus::Error>;
    fn plugin(&self) -> Result<String, dbus::Error>;
    fn primary_port(&self) -> Result<String, dbus::Error>;
    fn ports(&self) -> Result<Vec<(String, u32)>, dbus::Error>;
    fn equipment_identifier(&self) -> Result<String, dbus::Error>;
    fn unlock_required(&self) -> Result<u32, dbus::Error>;
    fn unlock_retries(&self) -> Result<::std::collections::HashMap<u32, u32>, dbus::Error>;
    fn state(&self) -> Result<i32, dbus::Error>;
    fn state_failed_reason(&self) -> Result<u32, dbus::Error>;
    fn access_technologies(&self) -> Result<u32, dbus::Error>;
    fn signal_quality(&self) -> Result<(u32, bool), dbus::Error>;
    fn own_numbers(&self) -> Result<Vec<String>, dbus::Error>;
    fn power_state(&self) -> Result<u32, dbus::Error>;
    fn supported_modes(&self) -> Result<Vec<(u32, u32)>, dbus::Error>;
    fn current_modes(&self) -> Result<(u32, u32), dbus::Error>;
    fn supported_bands(&self) -> Result<Vec<u32>, dbus::Error>;
    fn current_bands(&self) -> Result<Vec<u32>, dbus::Error>;
    fn supported_ip_families(&self) -> Result<u32, dbus::Error>;
}

#[derive(Debug)]
pub struct ModemStateChanged {
    pub old: i32,
    pub new: i32,
    pub reason: u32,
}

impl arg::AppendAll for ModemStateChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.old, i);
        arg::RefArg::append(&self.new, i);
        arg::RefArg::append(&self.reason, i);
    }
}

impl arg::ReadAll for ModemStateChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemStateChanged {
            old: i.read()?,
            new: i.read()?,
            reason: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemStateChanged {
    const NAME: &'static str = "StateChanged";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> Modem for blocking::Proxy<'a, C> {

    fn enable(&self, enable: bool) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "Enable", (enable, ))
    }

    fn list_bearers(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "ListBearers", ())
            .and_then(|r: (Vec<dbus::Path<'static>>, )| Ok(r.0, ))
    }

    fn create_bearer(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "CreateBearer", (properties, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn delete_bearer(&self, bearer: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "DeleteBearer", (bearer, ))
    }

    fn reset(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "Reset", ())
    }

    fn factory_reset(&self, code: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "FactoryReset", (code, ))
    }

    fn set_power_state(&self, state: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "SetPowerState", (state, ))
    }

    fn set_current_capabilities(&self, capabilities: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "SetCurrentCapabilities", (capabilities, ))
    }

    fn set_current_modes(&self, modes: (u32, u32)) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "SetCurrentModes", (modes, ))
    }

    fn set_current_bands(&self, bands: Vec<u32>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "SetCurrentBands", (bands, ))
    }

    fn set_primary_sim_slot(&self, sim_slot: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "SetPrimarySimSlot", (sim_slot, ))
    }

    fn command(&self, cmd: &str, timeout: u32) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem", "Command", (cmd, timeout, ))
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn sim(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Sim")
    }

    fn sim_slots(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SimSlots")
    }

    fn primary_sim_slot(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "PrimarySimSlot")
    }

    fn bearers(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Bearers")
    }

    fn supported_capabilities(&self) -> Result<Vec<u32>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SupportedCapabilities")
    }

    fn current_capabilities(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "CurrentCapabilities")
    }

    fn max_bearers(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "MaxBearers")
    }

    fn max_active_bearers(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "MaxActiveBearers")
    }

    fn max_active_multiplexed_bearers(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "MaxActiveMultiplexedBearers")
    }

    fn manufacturer(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Manufacturer")
    }

    fn model(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Model")
    }

    fn revision(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Revision")
    }

    fn carrier_configuration(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "CarrierConfiguration")
    }

    fn carrier_configuration_revision(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "CarrierConfigurationRevision")
    }

    fn hardware_revision(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "HardwareRevision")
    }

    fn device_identifier(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "DeviceIdentifier")
    }

    fn device(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Device")
    }

    fn drivers(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Drivers")
    }

    fn plugin(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Plugin")
    }

    fn primary_port(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "PrimaryPort")
    }

    fn ports(&self) -> Result<Vec<(String, u32)>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "Ports")
    }

    fn equipment_identifier(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "EquipmentIdentifier")
    }

    fn unlock_required(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "UnlockRequired")
    }

    fn unlock_retries(&self) -> Result<::std::collections::HashMap<u32, u32>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "UnlockRetries")
    }

    fn state(&self) -> Result<i32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "State")
    }

    fn state_failed_reason(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "StateFailedReason")
    }

    fn access_technologies(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "AccessTechnologies")
    }

    fn signal_quality(&self) -> Result<(u32, bool), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SignalQuality")
    }

    fn own_numbers(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "OwnNumbers")
    }

    fn power_state(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "PowerState")
    }

    fn supported_modes(&self) -> Result<Vec<(u32, u32)>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SupportedModes")
    }

    fn current_modes(&self) -> Result<(u32, u32), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "CurrentModes")
    }

    fn supported_bands(&self) -> Result<Vec<u32>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SupportedBands")
    }

    fn current_bands(&self) -> Result<Vec<u32>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "CurrentBands")
    }

    fn supported_ip_families(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem", "SupportedIpFamilies")
    }
}
