// This code was autogenerated with dbus-codegen-rust
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait ModemMessaging {
    fn list(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn delete(&self, path: dbus::Path) -> Result<(), dbus::Error>;
    fn create(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error>;
    fn messages(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn supported_storages(&self) -> Result<Vec<u32>, dbus::Error>;
    fn default_storage(&self) -> Result<u32, dbus::Error>;
}

#[derive(Debug)]
pub struct ModemMessagingAdded {
    pub path: dbus::Path<'static>,
    pub received: bool,
}

impl arg::AppendAll for ModemMessagingAdded {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.path, i);
        arg::RefArg::append(&self.received, i);
    }
}

impl arg::ReadAll for ModemMessagingAdded {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemMessagingAdded {
            path: i.read()?,
            received: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemMessagingAdded {
    const NAME: &'static str = "Added";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem.Messaging";
}

#[derive(Debug)]
pub struct ModemMessagingDeleted {
    pub path: dbus::Path<'static>,
}

impl arg::AppendAll for ModemMessagingDeleted {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.path, i);
    }
}

impl arg::ReadAll for ModemMessagingDeleted {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ModemMessagingDeleted {
            path: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ModemMessagingDeleted {
    const NAME: &'static str = "Deleted";
    const INTERFACE: &'static str = "org.freedesktop.ModemManager1.Modem.Messaging";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> ModemMessaging for blocking::Proxy<'a, C> {

    fn list(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Messaging", "List", ())
            .and_then(|r: (Vec<dbus::Path<'static>>, )| Ok(r.0, ))
    }

    fn delete(&self, path: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Messaging", "Delete", (path, ))
    }

    fn create(&self, properties: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.ModemManager1.Modem.Messaging", "Create", (properties, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn messages(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem.Messaging", "Messages")
    }

    fn supported_storages(&self) -> Result<Vec<u32>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem.Messaging", "SupportedStorages")
    }

    fn default_storage(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.ModemManager1.Modem.Messaging", "DefaultStorage")
    }
}
