List of things to finish before I consider this library ready for public
consumption:

[ ] Define an actual public API.
    * Going to split the API into two parts, a low-level API and a high-level
      API.
    * Low Level will consist of Register structs, the CalibrationData trait,
      others? The purpose of the low-level API is to allow users of this library
      who need to save a handful of bytes or CPU cycles to do that if they know
      what they're doing.
    * User story (taken from an issue on the Melexis mlx90640 GitHub repo): Sam
      is using a very memory constrained microcontroller, and to reduce RAM 
      usage has stored the calculated EEPROM constants in the microcontroller's 
      flash. This can be facilitated by mlx9064x by exposing the 
      CalibrationData trait and having the overall camera operations generic 
      over the trait.
    * User story: Alex is trying to squeeze as much throughput as possible out
      of their hardware, so they're batching every register access they can. The
      high level interface (in this story at least) is cautios and does a
      read-update-write cycle, but Alex knows the exact values the registers 
      need to be for maximum performance. Right now the Register srtuctures 
      aren't exposed publicly, but they should be. The read and write functions
      for the registers should also be rewritten so they only do *exactly* 
      what's required, and nothing more (and use the high level API to build in 
      the cautious part).

[ ] Implement MLX90641 support.
